/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.retriever;

import com.liferay.account.retriever.AccountOrganizationRetriever;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountOrganizationRetriever.class})
public class AccountOrganizationRetrieverImpl
implements AccountOrganizationRetriever {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;

    public BaseModelSearchResult<Organization> searchAccountOrganizations(long accountEntryId, String keywords, int cur, int delta, String sortField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(accountEntryId, keywords, cur, delta, sortField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List organizations = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long organizationId = document.getLong("organizationId");
            return this._organizationLocalService.getOrganization(organizationId);
        });
        return new BaseModelSearchResult(organizations, searchResponse.getTotalHits());
    }

    private SearchRequest _getSearchRequest(long accountEntryId, String keywords, int cur, int delta, String sortField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{Organization.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, accountEntryId, keywords));
        if (cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(cur));
            searchRequestBuilder.size(Integer.valueOf(delta));
        }
        if (Validator.isNotNull((String)sortField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(Organization.class.getName(), sortField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private void _populateSearchContext(SearchContext searchContext, long accountEntryId, String keywords) {
        searchContext.setCompanyId(CompanyThreadLocal.getCompanyId().longValue());
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        searchContext.setAttribute("accountEntryIds", (Serializable)new long[]{accountEntryId});
    }
}

