/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermission;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchPermissionFilterContributor.class})
public class AccountEntrySearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntrySearchPermissionFilterContributor.class);
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrganizationPermission _organizationPermission;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(AccountEntry.class.getName())) {
            return;
        }
        this._addAccountUserIdsFilters(booleanFilter, userId);
        this._addOrganizationIdsFilter(booleanFilter, companyId, userId, permissionChecker);
    }

    private void _addAccountUserIdsFilters(BooleanFilter booleanFilter, long userId) {
        TermsFilter accountUserIdsTermsFilter = new TermsFilter("accountUserIds");
        accountUserIdsTermsFilter.addValue(String.valueOf(userId));
        booleanFilter.add((Filter)accountUserIdsTermsFilter, BooleanClauseOccur.SHOULD);
    }

    private void _addOrganizationIdsFilter(BooleanFilter booleanFilter, long companyId, long userId, PermissionChecker permissionChecker) {
        TermsFilter organizationIdsTermsFilter = new TermsFilter("organizationIds");
        try {
            HashSet<Organization> organizationsSet = new HashSet<Organization>();
            for (Organization organization : this._organizationLocalService.getUserOrganizations(userId)) {
                boolean hasManageAvailableAccountsPermission = this._organizationPermission.contains(permissionChecker, organization.getOrganizationId(), "MANAGE_AVAILABLE_ACCOUNTS");
                if (hasManageAvailableAccountsPermission || this._organizationPermission.contains(permissionChecker, organization, "MANAGE_ACCOUNTS")) {
                    organizationsSet.add(organization);
                }
                if (!hasManageAvailableAccountsPermission && !this._organizationPermission.contains(permissionChecker, organization, "MANAGE_SUBORGANIZATIONS_ACCOUNTS")) continue;
                List suborganizations = this._organizationLocalService.getSuborganizations(organization.getCompanyId(), organization.getOrganizationId());
                while (!suborganizations.isEmpty()) {
                    organizationsSet.addAll(suborganizations);
                    suborganizations = this._organizationLocalService.getSuborganizations(suborganizations);
                }
            }
            BaseModelSearchResult baseModelSearchResult = this._organizationLocalService.searchOrganizations(companyId, -1L, null, LinkedHashMapBuilder.put((Object)"accountsOrgsTree", (Object)ListUtil.fromCollection(organizationsSet)).build(), -1, -1, null);
            for (Organization organization : baseModelSearchResult.getBaseModels()) {
                organizationIdsTermsFilter.addValue(String.valueOf(organization.getOrganizationId()));
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        if (!organizationIdsTermsFilter.isEmpty()) {
            booleanFilter.add((Filter)organizationIdsTermsFilter, BooleanClauseOccur.SHOULD);
        }
    }
}

