/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchPermissionFilterContributor.class})
public class AccountRoleSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleSearchPermissionFilterContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountRole)")
    private ModelResourcePermission<AccountRole> _accountRoleModelResourcePermission;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(AccountRole.class.getName())) {
            return;
        }
        try {
            this._addAccountRoleIdsFilter(booleanFilter, companyId, userId, permissionChecker);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _addAccountRoleIdsFilter(BooleanFilter booleanFilter, long companyId, long userId, PermissionChecker permissionChecker) throws PortalException {
        TermsFilter classPksFilter = new TermsFilter("entryClassPK");
        HashSet<Long> accountRoleIds = new HashSet<Long>();
        ArrayList<Long> accountEntryIds = new ArrayList<Long>();
        long permissionAccountEntryId = AccountRolePermissionThreadLocal.getAccountEntryId();
        if (permissionAccountEntryId != 0L) {
            accountEntryIds.add(permissionAccountEntryId);
        }
        if (accountEntryIds.isEmpty()) {
            List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(0L), null, new String[]{"business", "person"}, -1, -1);
            for (AccountEntry accountEntry : accountEntries) {
                accountEntryIds.add(accountEntry.getAccountEntryId());
            }
        }
        Iterator iterator = accountEntryIds.iterator();
        while (iterator.hasNext()) {
            long accountEntryId = (Long)iterator.next();
            List accountRoles = this._accountRoleLocalService.getAccountRolesByAccountEntryIds(companyId, new long[]{0L, accountEntryId});
            SafeCloseable safeCloseable = AccountRolePermissionThreadLocal.setWithSafeCloseable((long)accountEntryId);
            Throwable throwable = null;
            try {
                for (AccountRole accountRole : accountRoles) {
                    if (accountRoleIds.contains(accountRole.getRoleId()) || !this._accountRoleModelResourcePermission.contains(permissionChecker, accountRole.getAccountRoleId(), "VIEW")) continue;
                    accountRoleIds.add(accountRole.getAccountRoleId());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
        iterator = accountRoleIds.iterator();
        while (iterator.hasNext()) {
            long accountRoleId = (Long)iterator.next();
            classPksFilter.addValue(String.valueOf(accountRoleId));
        }
        if (!classPksFilter.isEmpty()) {
            booleanFilter.add((Filter)classPksFilter, BooleanClauseOccur.SHOULD);
        }
    }
}

