/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.account.model.AccountEntry"}, service={ModelPreFilterContributor.class})
public class AccountEntryModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByAccountGroupIds(booleanFilter, searchContext);
        this._filterByAccountUserIds(booleanFilter, searchContext);
        this._filterByAllowNewUserMembership(booleanFilter, searchContext);
        this._filterByDomains(booleanFilter, searchContext);
        this._filterByOrganizationIds(booleanFilter, searchContext);
        this._filterByParentAccountEntryId(booleanFilter, searchContext);
        this._filterByStatus(booleanFilter, searchContext);
        this._filterByTypes(booleanFilter, searchContext);
    }

    private void _filterByAccountGroupIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] accountGroupIds = (long[])searchContext.getAttribute("accountGroupIds");
        if (ArrayUtil.isNotEmpty((long[])accountGroupIds)) {
            TermsFilter termsFilter = new TermsFilter("accountGroupIds");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])accountGroupIds));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByAccountUserIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] accountUserIds = (long[])searchContext.getAttribute("accountUserIds");
        if (ArrayUtil.isNotEmpty((long[])accountUserIds)) {
            TermsFilter termsFilter = new TermsFilter("accountUserIds");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])accountUserIds));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByAllowNewUserMembership(BooleanFilter booleanFilter, SearchContext searchContext) {
        Boolean allowNewUserMembership = (Boolean)searchContext.getAttribute("allowNewUserMembership");
        if (allowNewUserMembership != null) {
            booleanFilter.addRequiredTerm("allowNewUserMembership", allowNewUserMembership);
        }
    }

    private void _filterByDomains(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] domains = (String[])searchContext.getAttribute("domains");
        if (ArrayUtil.isNotEmpty((Object[])domains)) {
            TermsFilter termsFilter = new TermsFilter("domains");
            termsFilter.addValues((String[])domains);
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByOrganizationIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] organizationIds = (long[])searchContext.getAttribute("organizationIds");
        if (ArrayUtil.isNotEmpty((long[])organizationIds)) {
            TermsFilter termsFilter = new TermsFilter("organizationIds");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])organizationIds));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByParentAccountEntryId(BooleanFilter booleanFilter, SearchContext searchContext) {
        long parentAccountEntryId = GetterUtil.getLong((Object)searchContext.getAttribute("parentAccountEntryId"), (long)-1L);
        if (parentAccountEntryId != -1L) {
            booleanFilter.addRequiredTerm("parentAccountEntryId", String.valueOf(parentAccountEntryId));
        }
    }

    private void _filterByStatus(BooleanFilter booleanFilter, SearchContext searchContext) {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            booleanFilter.addRequiredTerm("status", String.valueOf(status));
        }
    }

    private void _filterByTypes(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] types = (String[])searchContext.getAttribute("types");
        if (ArrayUtil.isNotEmpty((Object[])types)) {
            TermsFilter termsFilter = new TermsFilter("type");
            termsFilter.addValues((String[])types);
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }
}

