/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.account.model.AccountRole"}, service={ModelPreFilterContributor.class})
public class AccountRoleModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByAccountEntryIds(booleanFilter, searchContext);
        this._filterByExcludedRoleNames(booleanFilter, searchContext);
    }

    private void _filterByAccountEntryIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] accountEntryIds = (long[])searchContext.getAttribute("accountEntryIds");
        if (ArrayUtil.isNotEmpty((long[])accountEntryIds)) {
            TermsFilter termsFilter = new TermsFilter("accountEntryId");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])accountEntryIds));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByExcludedRoleNames(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] excludedRoleNames = (String[])searchContext.getAttribute("excludedRoleNames");
        if (ArrayUtil.isNotEmpty((Object[])excludedRoleNames)) {
            TermsFilter termsFilter = new TermsFilter(Field.getSortableFieldName((String)"name"));
            for (Object excludedRoleName : excludedRoleNames) {
                termsFilter.addValue(StringUtil.lowerCase((String)excludedRoleName));
            }
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST_NOT);
        }
    }
}

