/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionLogic;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import java.util.List;

public class AccountPortletResourcePermissionLogic
implements PortletResourcePermissionLogic {
    private static final Log _log = LogFactoryUtil.getLog(AccountPortletResourcePermissionLogic.class);
    private final OrganizationLocalService _organizationLocalService;

    public AccountPortletResourcePermissionLogic(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
    }

    public Boolean contains(PermissionChecker permissionChecker, String name, Group group, String actionId) {
        block4: {
            if (permissionChecker.hasPermission(group, name, 0L, actionId)) {
                return true;
            }
            try {
                List organizations = this._organizationLocalService.getUserOrganizations(permissionChecker.getUserId(), true);
                for (Organization organization : organizations) {
                    if (!permissionChecker.hasPermission(organization.getGroupId(), name, 0L, actionId)) continue;
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)portalException);
            }
        }
        return false;
    }
}

