/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.permission.RolePermission;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.account.model.AccountRole"}, service={AccountRoleModelResourcePermission.class, ModelResourcePermission.class})
public class AccountRoleModelResourcePermission
implements ModelResourcePermission<AccountRole> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference(target="(resource.name=com.liferay.account)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private RolePermission _rolePermission;

    public void check(PermissionChecker permissionChecker, AccountRole accountRole, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountRole, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountRole.class.getName(), accountRole.getAccountRoleId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountRoleId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountRoleId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountRole.class.getName(), accountRoleId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountRole accountRole, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountRole.getAccountRoleId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountRoleId, String actionId) throws PortalException {
        AccountRole accountRole;
        Group group = null;
        long contextAccountEntryId = AccountRolePermissionThreadLocal.getAccountEntryId();
        if (contextAccountEntryId > 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(contextAccountEntryId);
            group = accountEntry.getAccountEntryGroup();
        }
        if ((accountRole = this._accountRoleLocalService.fetchAccountRole(accountRoleId)) == null) {
            return permissionChecker.hasPermission(group, AccountRole.class.getName(), 0L, actionId);
        }
        Role role = accountRole.getRole();
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), AccountRole.class.getName(), accountRoleId, role.getUserId(), actionId)) {
            return true;
        }
        long accountRoleAccountEntryId = accountRole.getAccountEntryId();
        if (accountRoleAccountEntryId > 0L && contextAccountEntryId > 0L && !Objects.equals(accountRoleAccountEntryId, contextAccountEntryId)) {
            return false;
        }
        for (long accountEntryId : new long[]{accountRoleAccountEntryId, contextAccountEntryId}) {
            if (Objects.equals(actionId, "VIEW") && accountEntryId > 0L && this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryId, "VIEW_ACCOUNT_ROLES") || this._rolePermission.contains(permissionChecker, role.getRoleId(), "VIEW")) {
                return true;
            }
            if (!Objects.equals(actionId, "ASSIGN_USERS") || accountEntryId <= 0L || !this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryId, "MANAGE_USERS")) continue;
            return true;
        }
        if (group == null && accountRoleAccountEntryId > 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountRoleAccountEntryId);
            group = accountEntry.getAccountEntryGroup();
        }
        return permissionChecker.hasPermission(group, AccountRole.class.getName(), accountRoleId, actionId);
    }

    public String getModelName() {
        return AccountRole.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

