/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.settings;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.internal.configuration.AccountEntryGroupConfiguration;
import com.liferay.account.settings.AccountEntryGroupSettings;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AccountEntryGroupSettings.class})
public class AccountEntryGroupSettingsImpl
implements AccountEntryGroupSettings,
ConfigurationModelListener {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryGroupSettingsImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    public String[] getAllowedTypes(long groupId) {
        try {
            AccountEntryGroupConfiguration accountEntryGroupConfiguration = (AccountEntryGroupConfiguration)this._configurationProvider.getGroupConfiguration(AccountEntryGroupConfiguration.class, groupId);
            return accountEntryGroupConfiguration.allowedTypes();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return AccountConstants.ACCOUNT_ENTRY_TYPES_DEFAULT_ALLOWED_TYPES;
        }
    }

    public void setAllowedTypes(long groupId, String[] allowedTypes) throws AccountEntryTypeException {
        try {
            if (allowedTypes == null) {
                this._configurationProvider.deleteGroupConfiguration(AccountEntryGroupConfiguration.class, groupId);
                return;
            }
            this._configurationProvider.saveGroupConfiguration(AccountEntryGroupConfiguration.class, groupId, (Dictionary)HashMapDictionaryBuilder.put((Object)"allowedTypes", (Object)allowedTypes).build());
        }
        catch (ConfigurationException configurationException) {
            throw new AccountEntryTypeException("Invalid account type", (Throwable)configurationException);
        }
    }
}

