/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.upgrade.v2_2_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Date;
import java.sql.PreparedStatement;

public class AccountGroupRelUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(AccountGroupRelUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;

    public AccountGroupRelUpgradeProcess(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.alterTableAddColumn("AccountGroupRel", "userId", "LONG");
        this.alterTableAddColumn("AccountGroupRel", "userName", "VARCHAR(75) null");
        this.alterTableAddColumn("AccountGroupRel", "createDate", "DATE null");
        this.alterTableAddColumn("AccountGroupRel", "modifiedDate", "DATE null");
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._updateDefaultValues((Company)company);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private void _updateDefaultValues(Company company) throws Exception {
        User defaultUser = company.getDefaultUser();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update AccountGroupRel set userId = ?, userName = ?, createDate = ?, modifiedDate = ? where companyId = ? and userId = 0");){
            preparedStatement.setLong(1, defaultUser.getUserId());
            preparedStatement.setString(2, defaultUser.getFullName());
            Date date = new Date(System.currentTimeMillis());
            preparedStatement.setDate(3, date);
            preparedStatement.setDate(4, date);
            preparedStatement.setLong(5, company.getCompanyId());
            preparedStatement.executeUpdate();
        }
    }
}

