/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.base;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.account.service.persistence.AccountEntryPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AccountEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AccountEntryLocalService,
AopService,
IdentifiableOSGiService {
    protected AccountEntryLocalService accountEntryLocalService;
    @Reference
    protected AccountEntryPersistence accountEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry addAccountEntry(AccountEntry accountEntry) {
        accountEntry.setNew(true);
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    @Transactional(enabled=false)
    public AccountEntry createAccountEntry(long accountEntryId) {
        return this.accountEntryPersistence.create(accountEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AccountEntry deleteAccountEntry(long accountEntryId) throws PortalException {
        return this.accountEntryPersistence.remove(accountEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AccountEntry deleteAccountEntry(AccountEntry accountEntry) throws PortalException {
        return (AccountEntry)this.accountEntryPersistence.remove((BaseModel)accountEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.accountEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(AccountEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.accountEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.accountEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.accountEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.accountEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.accountEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public AccountEntry fetchAccountEntry(long accountEntryId) {
        return this.accountEntryPersistence.fetchByPrimaryKey(accountEntryId);
    }

    public AccountEntry fetchAccountEntryByUuidAndCompanyId(String uuid, long companyId) {
        return this.accountEntryPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public AccountEntry fetchAccountEntryByExternalReferenceCode(long companyId, String externalReferenceCode) {
        return this.accountEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    @Deprecated
    public AccountEntry fetchAccountEntryByReferenceCode(long companyId, String externalReferenceCode) {
        return this.fetchAccountEntryByExternalReferenceCode(companyId, externalReferenceCode);
    }

    public AccountEntry getAccountEntryByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return this.accountEntryPersistence.findByC_ERC(companyId, externalReferenceCode);
    }

    public AccountEntry getAccountEntry(long accountEntryId) throws PortalException {
        return this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AccountEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(AccountEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("accountEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AccountEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<AccountEntry>(){

            public void performAction(AccountEntry accountEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)accountEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)AccountEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.accountEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.accountEntryLocalService.deleteAccountEntry((AccountEntry)persistedModel);
    }

    public BasePersistence<AccountEntry> getBasePersistence() {
        return this.accountEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.accountEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public AccountEntry getAccountEntryByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.accountEntryPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<AccountEntry> getAccountEntries(int start, int end) {
        return this.accountEntryPersistence.findAll(start, end);
    }

    public int getAccountEntriesCount() {
        return this.accountEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateAccountEntry(AccountEntry accountEntry) {
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AccountEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.accountEntryLocalService = (AccountEntryLocalService)aopProxy;
        this._setLocalServiceUtilService(this.accountEntryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return AccountEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return AccountEntry.class;
    }

    protected String getModelClassName() {
        return AccountEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.accountEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(AccountEntryLocalService accountEntryLocalService) {
        try {
            Field field = AccountEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, accountEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

