/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.exception.AccountEntryDomainsException;
import com.liferay.account.exception.AccountEntryEmailAddressException;
import com.liferay.account.exception.AccountEntryNameException;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.exception.DuplicateAccountEntryExternalReferenceCodeException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.model.AccountEntryUserRelTable;
import com.liferay.account.model.impl.AccountEntryImpl;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryLocalServiceBaseImpl;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={AopService.class})
public class AccountEntryLocalServiceImpl
extends AccountEntryLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserFileUploadsSettings _userFileUploadsSettings;
    @Reference
    private UserLocalService _userLocalService;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::activateAccountEntry));
    }

    public AccountEntry activateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 0);
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws PortalException {
        return this.activateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        long accountEntryId = this.counterLocalService.increment();
        AccountEntry accountEntry = this.accountEntryPersistence.create(accountEntryId);
        User user = this._userLocalService.getUser(userId);
        accountEntry.setCompanyId(user.getCompanyId());
        accountEntry.setUserId(user.getUserId());
        accountEntry.setUserName(user.getFullName());
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)AccountEntry.class.getName(), (String)"name");
        name = StringUtil.shorten((String)name, (int)nameMaxLength);
        this._validateName(name);
        accountEntry.setName(name);
        accountEntry.setDescription(description);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._validateEmailAddress(emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, true, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        this._validateType(type);
        accountEntry.setType(type);
        accountEntry.setStatus(status);
        accountEntry = (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
        this._groupLocalService.addGroup(userId, 0L, AccountEntry.class.getName(), accountEntryId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, false, true, null);
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AccountEntry.class.getName(), accountEntryId, false, false, false);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
            accountEntry.setExpandoBridgeAttributes(serviceContext);
        }
        return accountEntry;
    }

    public AccountEntry addOrUpdateAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        AccountEntry accountEntry = this.fetchAccountEntryByExternalReferenceCode(user.getCompanyId(), externalReferenceCode);
        if (accountEntry != null) {
            return this.updateAccountEntry(accountEntry.getAccountEntryId(), parentAccountEntryId, name, description, false, domains, emailAddress, logoBytes, taxIdNumber, status, serviceContext);
        }
        accountEntry = this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, emailAddress, logoBytes, taxIdNumber, type, status, serviceContext);
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::deactivateAccountEntry));
    }

    public AccountEntry deactivateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 5);
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws PortalException {
        return this.deactivateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)arg_0 -> ((AccountEntryLocalService)this.accountEntryLocalService).deleteAccountEntry(arg_0)));
    }

    public void deleteAccountEntriesByCompanyId(long companyId) {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            throw new UnsupportedOperationException("Deleting account entries by company must be called when deleting a company");
        }
        for (AccountEntry accountRole : this.accountEntryPersistence.findByCompanyId(companyId)) {
            this.accountEntryPersistence.remove((BaseModel)accountRole);
        }
    }

    @Override
    @SystemEvent(type=1)
    public AccountEntry deleteAccountEntry(AccountEntry accountEntry) throws PortalException {
        accountEntry = super.deleteAccountEntry(accountEntry);
        this._groupLocalService.deleteGroup(accountEntry.getAccountEntryGroup());
        this._resourceLocalService.deleteResource(accountEntry.getCompanyId(), AccountEntry.class.getName(), 4, accountEntry.getAccountEntryId());
        this._assetEntryLocalService.deleteEntry(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        this._expandoRowLocalService.deleteRows(accountEntry.getAccountEntryId());
        return accountEntry;
    }

    @Override
    public AccountEntry deleteAccountEntry(long accountEntryId) throws PortalException {
        return this.deleteAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public AccountEntry fetchPersonAccountEntry(long userId) {
        return this.accountEntryPersistence.fetchByU_T_First(userId, "person", null);
    }

    public AccountEntry fetchUserAccountEntry(long userId, long accountEntryId) {
        DSLQuery dslQuery;
        List accountEntries;
        JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE).from((Table)UserTable.INSTANCE).leftJoinOn((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Expression)UserTable.INSTANCE.userId));
        Predicate accountEntryTablePredicate = AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryUserRelTable.INSTANCE.accountEntryId).or((Expression)AccountEntryTable.INSTANCE.userId.eq((Expression)UserTable.INSTANCE.userId));
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isNotEmpty((Object[])organizationIds)) {
            joinStep = joinStep.leftJoinOn((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds));
            accountEntryTablePredicate = accountEntryTablePredicate.or((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryOrganizationRelTable.INSTANCE.accountEntryId));
        }
        if ((accountEntries = (List)this.dslQuery(dslQuery = (joinStep = joinStep.leftJoinOn((Table)AccountEntryTable.INSTANCE, accountEntryTablePredicate)).where(UserTable.INSTANCE.userId.eq((Object)userId).and((Expression)AccountEntryTable.INSTANCE.type.neq((Object)"guest")).and((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Object)accountEntryId))).limit(0, 1))).isEmpty()) {
            return null;
        }
        return (AccountEntry)accountEntries.get(0);
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) {
        return this.accountEntryPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getAccountEntriesCount(long companyId, int status) {
        return this.accountEntryPersistence.countByC_S(companyId, status);
    }

    public AccountEntry getGuestAccountEntry(long companyId) throws PortalException {
        User defaultUser = this._userLocalService.getDefaultUser(companyId);
        AccountEntryImpl accountEntryImpl = new AccountEntryImpl();
        accountEntryImpl.setAccountEntryId(-1L);
        accountEntryImpl.setCompanyId(defaultUser.getCompanyId());
        accountEntryImpl.setUserId(defaultUser.getUserId());
        accountEntryImpl.setUserName(defaultUser.getFullName());
        accountEntryImpl.setParentAccountEntryId(0L);
        accountEntryImpl.setEmailAddress(defaultUser.getEmailAddress());
        accountEntryImpl.setName(defaultUser.getFullName());
        accountEntryImpl.setType("guest");
        accountEntryImpl.setStatus(0);
        return accountEntryImpl;
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, int start, int end) throws PortalException {
        return this.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, -1, start, end);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end) throws PortalException {
        return this.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, status, start, end, null);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) throws PortalException {
        if (start == -1 && end == -1 && orderByComparator == null) {
            Map accountEntriesMap = this.accountEntryPersistence.fetchByPrimaryKeys(this._getUserAccountEntryIds(userId, parentAccountEntryId, keywords, types, status));
            if (accountEntriesMap.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<AccountEntry>(accountEntriesMap.values());
        }
        Table tempAccountEntryTable = this._getOrganizationsAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status).union((DSLQuery)this._getOwnerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status)).union((DSLQuery)this._getUerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status)).as("tempAccountEntry", (Table)AccountEntryTable.INSTANCE);
        return (List)this.dslQuery(DSLQueryFactoryUtil.selectDistinct((Table)tempAccountEntryTable).from(tempAccountEntryTable).orderBy(tempAccountEntryTable, orderByComparator).limit(start, end));
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types) throws PortalException {
        return this.getUserAccountEntriesCount(userId, parentAccountEntryId, keywords, types, -1);
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status) throws PortalException {
        Set<Serializable> accountEntryIds = this._getUserAccountEntryIds(userId, parentAccountEntryId, keywords, types, status);
        return accountEntryIds.size();
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, cur, delta, orderByField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List accountEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long accountEntryId = document.getLong("entryClassPK");
            AccountEntry accountEntry = this.fetchAccountEntry(accountEntryId);
            if (accountEntry == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(AccountEntry.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return accountEntry;
        });
        return new BaseModelSearchResult(accountEntries, searchResponse.getTotalHits());
    }

    public AccountEntry updateAccountEntry(long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.fetchByPrimaryKey(accountEntryId);
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        this._validateName(name);
        accountEntry.setDescription(description);
        accountEntry.setName(name);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._validateEmailAddress(emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, !deleteLogo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        accountEntry.setStatus(status);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
            accountEntry.setExpandoBridgeAttributes(serviceContext);
        }
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultBillingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultBillingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultShippingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultShippingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateExternalReferenceCode(AccountEntry accountEntry, String externalReferenceCode) throws PortalException {
        if (Objects.equals(accountEntry.getExternalReferenceCode(), externalReferenceCode)) {
            return accountEntry;
        }
        this._validateExternalReferenceCode(accountEntry.getAccountEntryId(), externalReferenceCode);
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateExternalReferenceCode(long accountEntryId, String externalReferenceCode) throws PortalException {
        return this.updateExternalReferenceCode(this.getAccountEntry(accountEntryId), externalReferenceCode);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(AccountEntry accountEntry, int status) {
        accountEntry.setStatus(status);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(long accountEntryId, int status) throws PortalException {
        return this.updateStatus(this.getAccountEntry(accountEntryId), status);
    }

    private Predicate _getAccountEntryWherePredicate(Long parentAccountId, String keywords, String[] types, Integer status) {
        Predicate predicate = null;
        if (parentAccountId != null) {
            predicate = Predicate.and(predicate, (Predicate)AccountEntryTable.INSTANCE.parentAccountEntryId.eq((Object)parentAccountId));
        }
        if (Validator.isNotNull((String)keywords)) {
            Predicate keywordsPredicate = this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)AccountEntryTable.INSTANCE.name), this._customSQL.keywords(keywords, true));
            if (Validator.isDigit((String)keywords)) {
                keywordsPredicate = Predicate.or((Predicate)AccountEntryTable.INSTANCE.accountEntryId.eq((Object)Long.valueOf(keywords)), (Predicate)keywordsPredicate);
            }
            keywordsPredicate = Predicate.or((Predicate)AccountEntryTable.INSTANCE.externalReferenceCode.eq((Object)keywords), (Predicate)keywordsPredicate);
            predicate = Predicate.and((Predicate)predicate, (Predicate)Predicate.withParentheses((Predicate)keywordsPredicate));
        }
        if (types != null) {
            predicate = Predicate.and((Predicate)predicate, (Predicate)AccountEntryTable.INSTANCE.type.in((Object[])types));
        }
        if (status != null && status != -1) {
            predicate = Predicate.and((Predicate)predicate, (Predicate)AccountEntryTable.INSTANCE.status.eq((Object)status));
        }
        return predicate;
    }

    private Long[] _getOrganizationIds(long userId) {
        List organizations = this._organizationLocalService.getUserOrganizations(userId);
        ListIterator<Organization> listIterator = organizations.listIterator();
        while (listIterator.hasNext()) {
            Organization organization = (Organization)listIterator.next();
            for (Organization curOrganization : this._organizationLocalService.getOrganizations(organization.getCompanyId(), organization.getTreePath() + "%")) {
                listIterator.add(curOrganization);
            }
        }
        Stream stream = organizations.stream();
        return (Long[])stream.map(OrganizationModel::getOrganizationId).distinct().toArray(Long[]::new);
    }

    private GroupByStep _getOrganizationsAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        JoinStep joinStep = fromStep.from((Table)AccountEntryTable.INSTANCE);
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isEmpty((Object[])organizationIds)) {
            return joinStep.where(AccountEntryTable.INSTANCE.accountEntryId.eq((Object)-1L));
        }
        return joinStep.innerJoinON((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private GroupByStep _getOwnerAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        return fromStep.from((Table)AccountEntryTable.INSTANCE).where(AccountEntryTable.INSTANCE.userId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{AccountEntry.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params));
        if (cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(cur));
            searchRequestBuilder.size(Integer.valueOf(delta));
        }
        if (Validator.isNotNull((String)orderByField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(AccountEntry.class.getName(), orderByField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private GroupByStep _getUerAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        return fromStep.from((Table)AccountEntryTable.INSTANCE).innerJoinON((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private Set<Serializable> _getUserAccountEntryIds(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status) {
        HashSet<Serializable> accountEntryIds = new HashSet<Serializable>();
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getOrganizationsAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getOwnerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getUerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        return accountEntryIds;
    }

    private void _performActions(long[] accountEntryIds, ActionableDynamicQuery.PerformActionMethod<AccountEntry> performActionMethod) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Object[])ArrayUtil.toArray((long[])accountEntryIds))));
        actionableDynamicQuery.setPerformActionMethod(performActionMethod);
        actionableDynamicQuery.performActions();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params) {
        long permissionUserId;
        long parentAccountEntryId;
        long[] organizationIds;
        Boolean allowNewUserMembership;
        Object[] domains;
        long[] accountUserIds;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] accountGroupIds = (long[])params.get("accountGroupIds");
        if (ArrayUtil.isNotEmpty((long[])accountGroupIds)) {
            searchContext.setAttribute("accountGroupIds", (Serializable)accountGroupIds);
        }
        if (ArrayUtil.isNotEmpty((long[])(accountUserIds = (long[])params.get("accountUserIds")))) {
            searchContext.setAttribute("accountUserIds", (Serializable)accountUserIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])(domains = (String[])params.get("domains")))) {
            searchContext.setAttribute("domains", (Serializable)domains);
        }
        if ((allowNewUserMembership = (Boolean)params.get("allowNewUserMembership")) != null) {
            searchContext.setAttribute("allowNewUserMembership", (Serializable)allowNewUserMembership);
        }
        if (ArrayUtil.isNotEmpty((long[])(organizationIds = (long[])params.get("organizationIds")))) {
            searchContext.setAttribute("organizationIds", (Serializable)organizationIds);
        }
        if ((parentAccountEntryId = GetterUtil.getLong((Object)params.get("parentAccountEntryId"), (long)-1L)) != -1L) {
            searchContext.setAttribute("parentAccountEntryId", (Serializable)Long.valueOf(parentAccountEntryId));
        }
        int status = GetterUtil.getInteger((Object)params.get("status"), (int)0);
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        Object[] types = (String[])params.get("types");
        if (ArrayUtil.isNotEmpty((Object[])types)) {
            searchContext.setAttribute("types", (Serializable)types);
        }
        if ((permissionUserId = GetterUtil.getLong((Object)params.get("permissionUserId"))) != 0L) {
            searchContext.setUserId(permissionUserId);
        }
    }

    private void _updateAsset(AccountEntry accountEntry, ServiceContext serviceContext) throws PortalException {
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), company.getGroupId(), accountEntry.getCreateDate(), accountEntry.getModifiedDate(), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), null, 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, null, null, null, accountEntry.getName(), accountEntry.getDescription(), null, null, null, 0, 0, null);
    }

    private String[] _validateDomains(String[] domains) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])domains)) {
            return domains;
        }
        DomainValidator domainValidator = DomainValidator.getInstance();
        for (String domain : domains) {
            if (domainValidator.isValid(domain)) continue;
            throw new AccountEntryDomainsException();
        }
        return ArrayUtil.distinct((String[])domains);
    }

    private void _validateEmailAddress(String emailAddress) throws AccountEntryEmailAddressException {
        EmailValidator emailValidator;
        if (Validator.isNotNull((String)emailAddress) && !(emailValidator = EmailValidator.getInstance()).isValid(emailAddress)) {
            throw new AccountEntryEmailAddressException();
        }
    }

    private void _validateExternalReferenceCode(long accountEntryId, String externalReferenceCode) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        if ((accountEntry = this.fetchAccountEntryByExternalReferenceCode(accountEntry.getCompanyId(), externalReferenceCode)) == null) {
            return;
        }
        if (accountEntry.getAccountEntryId() != accountEntryId) {
            throw new DuplicateAccountEntryExternalReferenceCodeException();
        }
    }

    private void _validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AccountEntryNameException("Name is null");
        }
    }

    private void _validateType(String type) throws PortalException {
        if (!ArrayUtil.contains((Object[])AccountConstants.ACCOUNT_ENTRY_TYPES, (Object)type)) {
            throw new AccountEntryTypeException(StringBundler.concat((String[])new String[]{"Type \"", type, "\" is not among allowed types: ", StringUtil.merge((Object[])AccountConstants.ACCOUNT_ENTRY_TYPES, (String)", ")}));
        }
    }
}

