/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.exception.DuplicateAccountEntryOrganizationRelException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryOrganizationRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntryOrganizationRel"}, service={AopService.class})
public class AccountEntryOrganizationRelLocalServiceImpl
extends AccountEntryOrganizationRelLocalServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public AccountEntryOrganizationRel addAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        if (this.hasAccountEntryOrganizationRel(accountEntryId, organizationId)) {
            throw new DuplicateAccountEntryOrganizationRelException();
        }
        this._accountEntryLocalService.getAccountEntry(accountEntryId);
        this._organizationLocalService.getOrganization(organizationId);
        AccountEntryOrganizationRel accountEntryOrganizationRel = this.createAccountEntryOrganizationRel(this.counterLocalService.increment());
        accountEntryOrganizationRel.setAccountEntryId(accountEntryId);
        accountEntryOrganizationRel.setOrganizationId(organizationId);
        accountEntryOrganizationRel = this.updateAccountEntryOrganizationRel(accountEntryOrganizationRel);
        this._reindexAccountEntry(accountEntryId);
        this._reindexOrganization(organizationId);
        return accountEntryOrganizationRel;
    }

    public void addAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds) throws PortalException {
        if (organizationIds == null) {
            return;
        }
        for (long organizationId : organizationIds) {
            this.addAccountEntryOrganizationRel(accountEntryId, organizationId);
        }
    }

    public void deleteAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        this.accountEntryOrganizationRelPersistence.removeByA_O(accountEntryId, organizationId);
        this._reindexAccountEntry(accountEntryId);
        this._reindexOrganization(organizationId);
    }

    public void deleteAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds) throws PortalException {
        for (long organizationId : organizationIds) {
            this.deleteAccountEntryOrganizationRel(accountEntryId, organizationId);
        }
    }

    public void deleteAccountEntryOrganizationRelsByAccountEntryId(long accountEntryId) {
        this.accountEntryOrganizationRelPersistence.removeByAccountEntryId(accountEntryId);
    }

    public void deleteAccountEntryOrganizationRelsByOrganizationId(long organizationId) {
        this.accountEntryOrganizationRelPersistence.removeByOrganizationId(organizationId);
    }

    public AccountEntryOrganizationRel fetchAccountEntryOrganizationRel(long accountEntryId, long organizationId) {
        return this.accountEntryOrganizationRelPersistence.fetchByA_O(accountEntryId, organizationId);
    }

    public AccountEntryOrganizationRel getAccountEntryOrganizationRel(long accountEntryId, long organizationId) throws PortalException {
        return this.accountEntryOrganizationRelPersistence.findByA_O(accountEntryId, organizationId);
    }

    public List<AccountEntryOrganizationRel> getAccountEntryOrganizationRels(long accountEntryId) {
        return this.accountEntryOrganizationRelPersistence.findByAccountEntryId(accountEntryId);
    }

    public List<AccountEntryOrganizationRel> getAccountEntryOrganizationRels(long accountEntryId, int start, int end) {
        return this.accountEntryOrganizationRelPersistence.findByAccountEntryId(accountEntryId, start, end);
    }

    public List<AccountEntryOrganizationRel> getAccountEntryOrganizationRelsByOrganizationId(long organizationId) {
        return this.accountEntryOrganizationRelPersistence.findByOrganizationId(organizationId);
    }

    public List<AccountEntryOrganizationRel> getAccountEntryOrganizationRelsByOrganizationId(long organizationId, int start, int end) {
        return this.accountEntryOrganizationRelPersistence.findByOrganizationId(organizationId, start, end);
    }

    public int getAccountEntryOrganizationRelsByOrganizationIdCount(long organizationId) {
        return this.accountEntryOrganizationRelPersistence.countByOrganizationId(organizationId);
    }

    public int getAccountEntryOrganizationRelsCount(long accountEntryId) {
        return this.accountEntryOrganizationRelPersistence.countByAccountEntryId(accountEntryId);
    }

    public boolean hasAccountEntryOrganizationRel(long accountEntryId, long organizationId) {
        AccountEntryOrganizationRel accountEntryOrganizationRel = this.accountEntryOrganizationRelPersistence.fetchByA_O(accountEntryId, organizationId);
        return accountEntryOrganizationRel != null;
    }

    public void setAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds) throws PortalException {
        if (organizationIds == null) {
            return;
        }
        Set newOrganizationIdsSet = SetUtil.fromArray((long[])organizationIds);
        Set oldOrganizationIdsSet = SetUtil.fromCollection((Collection)ListUtil.toList(this.getAccountEntryOrganizationRels(accountEntryId), AccountEntryOrganizationRelModel::getOrganizationId));
        HashSet removeOrganizationIdsSet = new HashSet(oldOrganizationIdsSet);
        removeOrganizationIdsSet.removeAll(newOrganizationIdsSet);
        this.deleteAccountEntryOrganizationRels(accountEntryId, ArrayUtil.toLongArray(removeOrganizationIdsSet));
        newOrganizationIdsSet.removeAll(oldOrganizationIdsSet);
        this.addAccountEntryOrganizationRels(accountEntryId, ArrayUtil.toLongArray((Collection)newOrganizationIdsSet));
    }

    private void _reindexAccountEntry(long accountEntryId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountEntry.class);
        indexer.reindex(AccountEntry.class.getName(), accountEntryId);
    }

    private void _reindexOrganization(long organizationId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
        indexer.reindex(Organization.class.getName(), organizationId);
    }
}

