/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.base.AccountEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermission;
import com.liferay.portal.kernel.service.permission.PortalPermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountEntry"}, service={AopService.class})
public class AccountEntryServiceImpl
extends AccountEntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private OrganizationPermission _organizationPermission;
    @Reference
    private PortalPermission _portalPermission;
    @Reference
    private UserLocalService _userLocalService;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.activateAccountEntry(accountEntryId);
        }
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        return this.accountEntryLocalService.activateAccountEntry(accountEntryId);
    }

    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, String email, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        this._portalPermission.check(this.getPermissionChecker(), "ADD_ACCOUNT_ENTRY");
        return this.accountEntryLocalService.addAccountEntry(userId, parentAccountEntryId, name, description, domains, email, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public AccountEntry addOrUpdateAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        AccountEntry accountEntry = this.accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(permissionChecker.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            this._portalPermission.check(permissionChecker, "ADD_ACCOUNT_ENTRY");
        } else {
            this._accountEntryModelResourcePermission.check(permissionChecker, permissionChecker.getCompanyId(), "UPDATE");
        }
        return this.accountEntryLocalService.addOrUpdateAccountEntry(externalReferenceCode, userId, parentAccountEntryId, name, description, domains, emailAddress, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.deactivateAccountEntry(accountEntryId);
        }
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "DELETE");
        return this.accountEntryLocalService.deactivateAccountEntry(accountEntryId);
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            this.deleteAccountEntry(accountEntryId);
        }
    }

    public void deleteAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "DELETE");
        this.accountEntryLocalService.deleteAccountEntry(accountEntryId);
    }

    public AccountEntry fetchAccountEntry(long accountEntryId) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW");
        return this.accountEntryLocalService.fetchAccountEntry(accountEntryId);
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, AccountEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.accountEntryLocalService.getAccountEntries(companyId, status, start, end, orderByComparator);
    }

    public AccountEntry getAccountEntry(long accountEntryId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryLocalService.getAccountEntry(accountEntryId);
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW");
        return accountEntry;
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("permissionUserId", permissionChecker.getUserId());
        return this.accountEntryLocalService.searchAccountEntries(permissionChecker.getCompanyId(), keywords, params, cur, delta, orderByField, reverse);
    }

    public AccountEntry updateAccountEntry(AccountEntry accountEntry) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountEntry, "UPDATE");
        return this.accountEntryLocalService.updateAccountEntry(accountEntry);
    }

    public AccountEntry updateAccountEntry(long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        return this.accountEntryLocalService.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, emailAddress, logoBytes, taxIdNumber, status, serviceContext);
    }

    public AccountEntry updateExternalReferenceCode(long accountEntryId, String externalReferenceCode) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "UPDATE");
        return this.accountEntryLocalService.updateExternalReferenceCode(accountEntryId, externalReferenceCode);
    }
}

