/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.configuration.AccountEntryEmailDomainsConfiguration;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.exception.AccountEntryUserRelEmailAddressException;
import com.liferay.account.exception.DuplicateAccountEntryIdException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.account.service.base.AccountEntryUserRelLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntryUserRel"}, service={AopService.class})
public class AccountEntryUserRelLocalServiceImpl
extends AccountEntryUserRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryUserRelLocalServiceImpl.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private UserLocalService _userLocalService;

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, accountUserId);
        if (accountEntryUserRel != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Account entry user relationship already exists for ", "account entry ", accountEntryId, " and user ", accountUserId}));
            }
            return accountEntryUserRel;
        }
        if (accountEntryId != 0L) {
            this._accountEntryLocalService.getAccountEntry(accountEntryId);
        }
        User accountUser = this._userLocalService.getUser(accountUserId);
        this._validateEmailAddress(accountEntryId, accountUser.getCompanyId(), accountUser.getEmailAddress());
        accountEntryUserRel = this.createAccountEntryUserRel(this.counterLocalService.increment());
        accountEntryUserRel.setAccountEntryId(accountEntryId);
        accountEntryUserRel.setAccountUserId(accountUserId);
        return this.addAccountEntryUserRel(accountEntryUserRel);
    }

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (accountEntryId != 0L) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            companyId = accountEntry.getCompanyId();
        }
        this._validateEmailAddress(accountEntryId, companyId, emailAddress);
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        boolean male = true;
        int birthdayMonth = Month.JANUARY.getValue();
        int birthdayDay = 1;
        int birthdayYear = 1970;
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, user.getUserId());
    }

    public AccountEntryUserRel addAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress, long[] accountRoleIds, String userExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        User user = null;
        if (Validator.isNotNull((String)userExternalReferenceCode)) {
            user = this._userLocalService.fetchUserByReferenceCode(serviceContext.getCompanyId(), userExternalReferenceCode);
        }
        if (user == null) {
            if (Validator.isNull((String)emailAddress)) {
                throw new AccountEntryUserRelEmailAddressException();
            }
            user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), emailAddress);
        }
        if (user == null) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            Group group = accountEntry.getAccountEntryGroup();
            long[] groupIds = new long[]{group.getGroupId()};
            if (serviceContext.getScopeGroupId() > 0L) {
                groupIds = ArrayUtil.append((long[])groupIds, (long)serviceContext.getScopeGroupId());
            }
            user = this._userLocalService.addUserWithWorkflow(serviceContext.getUserId(), serviceContext.getCompanyId(), true, "", "", true, "", emailAddress, serviceContext.getLocale(), emailAddress, "", emailAddress, 0L, 0L, true, 1, 1, 1970, "", groupIds, null, null, null, true, serviceContext);
            user.setExternalReferenceCode(userExternalReferenceCode);
            user = this._userLocalService.updateUser(user);
        }
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, user.getUserId());
        this.updateRoles(accountEntryId, user.getUserId(), accountRoleIds);
        return accountEntryUserRel;
    }

    public void addAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.addAccountEntryUserRel(accountEntryId, accountUserId);
        }
    }

    public AccountEntryUserRel addPersonTypeAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        this.deleteAccountEntryUserRelsByAccountEntryId(accountEntryId);
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, creatorUserId, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, jobTitle, serviceContext);
    }

    public void deleteAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        User user = this._userLocalService.getUserByEmailAddress(accountEntry.getCompanyId(), emailAddress);
        this.accountEntryUserRelPersistence.removeByAEI_AUI(accountEntry.getAccountEntryId(), user.getUserId());
    }

    public void deleteAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        for (long accountUserId : accountUserIds) {
            this.accountEntryUserRelPersistence.removeByAEI_AUI(accountEntryId, accountUserId);
        }
    }

    public void deleteAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        for (AccountEntryUserRel accountEntryUserRel : this.getAccountEntryUserRelsByAccountEntryId(accountEntryId)) {
            this.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public void deleteAccountEntryUserRelsByAccountUserId(long accountUserId) {
        for (AccountEntryUserRel accountEntryUserRel : this.getAccountEntryUserRelsByAccountUserId(accountUserId)) {
            this.deleteAccountEntryUserRel(accountEntryUserRel);
        }
    }

    public AccountEntryUserRel fetchAccountEntryUserRel(long accountEntryId, long accountUserId) {
        return this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, accountUserId);
    }

    public AccountEntryUserRel getAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        return this.accountEntryUserRelPersistence.findByAEI_AUI(accountEntryId, accountUserId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.findByAccountEntryId(accountEntryId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId, int start, int end) {
        return this.accountEntryUserRelPersistence.findByAccountEntryId(accountEntryId, start, end);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountUserId(long accountUserId) {
        return this.accountEntryUserRelPersistence.findByAccountUserId(accountUserId);
    }

    public long getAccountEntryUserRelsCountByAccountEntryId(long accountEntryId) {
        return this.accountEntryUserRelPersistence.countByAccountEntryId(accountEntryId);
    }

    public boolean hasAccountEntryUserRel(long accountEntryId, long userId) {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelPersistence.fetchByAEI_AUI(accountEntryId, userId);
        return accountEntryUserRel != null;
    }

    public boolean isAccountEntryUser(long userId) {
        return this.accountEntryUserRelPersistence.countByAccountUserId(userId) > 0;
    }

    public void setPersonTypeAccountEntryUser(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (!Objects.equals("person", accountEntry.getType())) {
            throw new AccountEntryTypeException();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating user for person account entry: " + accountEntryId));
        }
        ArrayList<AccountEntryUserRel> removeAccountEntryUserRels = new ArrayList<AccountEntryUserRel>(this.getAccountEntryUserRelsByAccountEntryId(accountEntryId));
        boolean currentAccountUser = removeAccountEntryUserRels.removeIf(accountEntryUserRel -> accountEntryUserRel.getAccountUserId() == userId);
        removeAccountEntryUserRels.forEach(accountEntryUserRel -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing user: " + accountEntryUserRel.getAccountUserId()));
            }
            this.deleteAccountEntryUserRel((AccountEntryUserRel)accountEntryUserRel);
        });
        if (userId > 0L && !currentAccountUser) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding user: " + userId));
            }
            this.addAccountEntryUserRel(accountEntryId, userId);
        }
    }

    public void updateAccountEntryUserRels(long[] addAccountEntryIds, long[] deleteAccountEntryIds, long accountUserId) throws PortalException {
        Set set = SetUtil.intersect((long[])addAccountEntryIds, (long[])deleteAccountEntryIds);
        if (!SetUtil.isEmpty((Set)set)) {
            throw new DuplicateAccountEntryIdException();
        }
        for (long addAccountEntryId : addAccountEntryIds) {
            if (this.hasAccountEntryUserRel(addAccountEntryId, accountUserId)) continue;
            this.addAccountEntryUserRel(addAccountEntryId, accountUserId);
        }
        for (long deleteAccountEntryId : deleteAccountEntryIds) {
            if (!this.hasAccountEntryUserRel(deleteAccountEntryId, accountUserId)) continue;
            this.accountEntryUserRelPersistence.removeByAEI_AUI(deleteAccountEntryId, accountUserId);
        }
    }

    protected void updateRoles(long accountEntryId, long userId, long[] accountRoleIds) throws PortalException {
        if (accountRoleIds == null) {
            return;
        }
        this._accountRoleLocalService.associateUser(accountEntryId, accountRoleIds, userId);
    }

    private void _validateEmailAddress(long accountEntryId, long companyId, String emailAddress) throws PortalException {
        int index = (emailAddress = StringUtil.toLowerCase((String)emailAddress.trim())).indexOf(64);
        if (index == -1) {
            return;
        }
        String domain = emailAddress.substring(index + 1);
        AccountEntryEmailDomainsConfiguration accountEntryEmailDomainsConfiguration = (AccountEntryEmailDomainsConfiguration)this._configurationProvider.getCompanyConfiguration(AccountEntryEmailDomainsConfiguration.class, companyId);
        Object[] blockedDomains = StringUtil.split((String)accountEntryEmailDomainsConfiguration.blockedEmailDomains(), (String)"\r\n");
        if (ArrayUtil.contains((Object[])blockedDomains, (Object)domain)) {
            throw new UserEmailAddressException.MustNotUseBlockedDomain(emailAddress, StringUtil.merge((Object[])blockedDomains, (String)", "));
        }
        if (!accountEntryEmailDomainsConfiguration.enableEmailDomainValidation()) {
            return;
        }
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
        if (accountEntry == null) {
            return;
        }
        Object[] domains = StringUtil.split((String)accountEntry.getDomains());
        if (ArrayUtil.isNotEmpty((Object[])domains) && !ArrayUtil.contains((Object[])domains, (Object)domain)) {
            throw new UserEmailAddressException.MustHaveValidDomain(emailAddress, accountEntry.getDomains());
        }
    }
}

