/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.base.AccountGroupRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountGroupRel"}, service={AopService.class})
public class AccountGroupRelServiceImpl
extends AccountGroupRelServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.account.model.AccountGroup)")
    private ModelResourcePermission<AccountGroup> _accountGroupModelResourcePermission;

    public AccountGroupRel addAccountGroupRel(long accountGroupId, String className, long classPK) throws PortalException {
        if (Objects.equals(AccountEntry.class.getName(), className)) {
            this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "ASSIGN_ACCOUNTS");
        }
        return this.accountGroupRelLocalService.addAccountGroupRel(accountGroupId, className, classPK);
    }

    public void addAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        if (Objects.equals(AccountEntry.class.getName(), className)) {
            this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "ASSIGN_ACCOUNTS");
        }
        this.accountGroupRelLocalService.addAccountGroupRels(accountGroupId, className, classPKs);
    }

    public void deleteAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        if (Objects.equals(AccountEntry.class.getName(), className)) {
            this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "ASSIGN_ACCOUNTS");
        }
        this.accountGroupRelLocalService.deleteAccountGroupRels(accountGroupId, className, classPKs);
    }
}

