/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.base.AccountGroupServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.permission.PortalPermission;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountGroup"}, service={AopService.class})
public class AccountGroupServiceImpl
extends AccountGroupServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.account.model.AccountGroup)")
    private ModelResourcePermission<AccountGroup> _accountGroupModelResourcePermission;
    @Reference
    private PortalPermission _portalPermission;

    public AccountGroup addAccountGroup(long userId, String description, String name) throws PortalException {
        this._portalPermission.check(this.getPermissionChecker(), "ADD_ACCOUNT_GROUP");
        return this.accountGroupLocalService.addAccountGroup(userId, description, name);
    }

    public AccountGroup deleteAccountGroup(long accountGroupId) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "DELETE");
        return this.accountGroupLocalService.deleteAccountGroup(accountGroupId);
    }

    public void deleteAccountGroups(long[] accountGroupIds) throws PortalException {
        for (long accountGroupId : accountGroupIds) {
            this.deleteAccountGroup(accountGroupId);
        }
    }

    public BaseModelSearchResult<AccountGroup> searchAccountGroups(long companyId, String keywords, int start, int end, OrderByComparator<AccountGroup> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        return this.accountGroupLocalService.searchAccountGroups(companyId, keywords, LinkedHashMapBuilder.put((Object)"permissionUserId", (Object)permissionChecker.getUserId()).build(), start, end, orderByComparator);
    }

    public AccountGroup updateAccountGroup(long accountGroupId, String description, String name) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "UPDATE");
        return this.accountGroupLocalService.updateAccountGroup(accountGroupId, description, name);
    }

    public AccountGroup updateExternalReferenceCode(long accountGroupId, String externalReferenceCode) throws PortalException {
        this._accountGroupModelResourcePermission.check(this.getPermissionChecker(), accountGroupId, "UPDATE");
        return this.accountGroupLocalService.updateExternalReferenceCode(accountGroupId, externalReferenceCode);
    }
}

