/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.blogs.web.internal.optimizer;

import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.optimizer.AMImageOptimizer;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"adaptive.media.key=blogs"}, service={AMImageOptimizer.class})
public class BlogsAMImageOptimizer
implements AMImageOptimizer {
    private static final Log _log = LogFactoryUtil.getLog(BlogsAMImageOptimizer.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference(target="(adaptive.media.key=blogs)")
    private AMImageCounter _amImageCounter;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageProcessor _amImageProcessor;
    @Reference
    private BackgroundTaskStatusMessageSender _backgroundTaskStatusMessageSender;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;

    public void optimize(long companyId) {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId);
        int count = this._amImageCounter.countExpectedAMImageEntries(companyId);
        int total = count * amImageConfigurationEntries.size();
        AtomicInteger successCounter = new AtomicInteger(0);
        AtomicInteger errorCounter = new AtomicInteger(0);
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this._optimize(companyId, amImageConfigurationEntry.getUUID(), total, successCounter, errorCounter);
        }
    }

    public void optimize(long companyId, String configurationEntryUuid) {
        int total = this._amImageCounter.countExpectedAMImageEntries(companyId);
        AtomicInteger successCounter = new AtomicInteger(0);
        AtomicInteger errorCounter = new AtomicInteger(0);
        this._optimize(companyId, configurationEntryUuid, total, successCounter, errorCounter);
    }

    private void _optimize(long companyId, String configurationEntryUuid, int total, AtomicInteger successCounter, AtomicInteger errorCounter) {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            long classNameId = this._classNameLocalService.getClassNameId(BlogsEntry.class.getName());
            dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
            Property mimeTypeProperty = PropertyFactoryUtil.forName((String)"mimeType");
            dynamicQuery.add(mimeTypeProperty.in((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes()));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            try {
                this._amImageProcessor.process(fileEntry.getFileVersion(), configurationEntryUuid);
                this._sendStatusMessage(successCounter.incrementAndGet(), errorCounter.get(), total);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to process file entry " + fileEntry.getFileEntryId()), (Throwable)exception);
                }
                this._sendStatusMessage(successCounter.get(), errorCounter.incrementAndGet(), total);
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }

    private void _sendStatusMessage(int count, int errors, int total) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        Class<?> clazz = this.getClass();
        message.put("className", (Object)clazz.getName());
        message.put("count", (Object)count);
        message.put("errors", (Object)errors);
        message.put("total", (Object)total);
        message.put("status", (Object)1);
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }
}

