/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.blogs.web.internal.counter;

import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLFileEntryConfiguration"}, property={"adaptive.media.key=blogs"}, service={AMImageCounter.class})
public class BlogsAMImageCounter
implements AMImageCounter {
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageValidator _amImageValidator;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private volatile DLFileEntryConfiguration _dlFileEntryConfiguration;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;

    public int countExpectedAMImageEntries(long companyId) {
        DynamicQuery dynamicQuery = this._dlFileEntryLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)this._classNameLocalService.getClassNameId(BlogsEntry.class.getName())));
        Property mimeTypeProperty = PropertyFactoryUtil.forName((String)"mimeType");
        dynamicQuery.add(mimeTypeProperty.in(ArrayUtil.filter((Object[])this._amImageMimeTypeProvider.getSupportedMimeTypes(), arg_0 -> ((AMImageValidator)this._amImageValidator).isProcessingSupported(arg_0))));
        Property sizeProperty = PropertyFactoryUtil.forName((String)"size");
        dynamicQuery.add(sizeProperty.le((Object)this._dlFileEntryConfiguration.previewableProcessorMaxSize()));
        return (int)this._dlFileEntryLocalService.dynamicQueryCount(dynamicQuery);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlFileEntryConfiguration = (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, properties);
    }
}

