/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.demo.internal;

import com.liferay.adaptive.media.demo.data.creator.AMImageConfigurationDemoDataCreator;
import com.liferay.document.library.demo.data.creator.FileEntryDemoDataCreator;
import com.liferay.document.library.demo.data.creator.RootFolderDemoDataCreator;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.users.admin.demo.data.creator.OmniAdminUserDemoDataCreator;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class AMImageDemo
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(AMImageDemo.class);
    @Reference
    private AMImageConfigurationDemoDataCreator _amImageConfigurationDemoDataCreator;
    @Reference
    private FileEntryDemoDataCreator _fileEntryDemoDataCreator;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private OmniAdminUserDemoDataCreator _omniAdminUserDemoDataCreator;
    @Reference
    private RootFolderDemoDataCreator _rootFolderDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        User user = this._omniAdminUserDemoDataCreator.create(company.getCompanyId(), "alejandro.hernandez@liferay.com");
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        Folder nonamFolder = this._rootFolderDemoDataCreator.create(user.getUserId(), group.getGroupId(), "Non Adaptive Media");
        for (int i = 0; i < 5; ++i) {
            FileEntry fileEntry = this._fileEntryDemoDataCreator.create(user.getUserId(), nonamFolder.getFolderId());
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Non adaptive media image created with file entry " + fileEntry.getFileEntryId()));
        }
        this._amImageConfigurationDemoDataCreator.create(company.getCompanyId());
        Folder amFolder = this._rootFolderDemoDataCreator.create(user.getUserId(), group.getGroupId(), "Adaptive Media");
        for (int i = 0; i < 5; ++i) {
            FileEntry fileEntry = this._fileEntryDemoDataCreator.create(user.getUserId(), amFolder.getFolderId());
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Adaptive media image created with file entry " + fileEntry.getFileEntryId()));
        }
    }

    @Deactivate
    protected void deactivate() throws IOException, PortalException {
        this._amImageConfigurationDemoDataCreator.delete();
        this._fileEntryDemoDataCreator.delete();
        this._rootFolderDemoDataCreator.delete();
        this._omniAdminUserDemoDataCreator.delete();
    }
}

