/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.internal.document.library.exportimport.data.handler;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntrySerializer;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.util.AMImageSerializer;
import com.liferay.adaptive.media.processor.AMProcessor;
import com.liferay.document.library.exportimport.data.handler.DLPluggableContentDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.xml.Element;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.repository.model.FileEntry"}, service={DLPluggableContentDataHandler.class})
public class AMImageDLPluggableContentDataHandler
implements DLPluggableContentDataHandler<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AMImageDLPluggableContentDataHandler.class);
    @Reference
    private AMImageConfigurationEntrySerializer _amImageConfigurationEntrySerializer;
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageSerializer _amImageSerializer;

    public void exportContent(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        if (!this._isEnabled(portletDataContext)) {
            return;
        }
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(portletDataContext.getCompanyId());
        amImageConfigurationEntries.forEach(amImageConfigurationEntry -> this._exportConfigurationEntry(portletDataContext, (AMImageConfigurationEntry)amImageConfigurationEntry));
        this._exportMedia(portletDataContext, fileEntry);
    }

    public void importContent(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry, FileEntry importedFileEntry) throws Exception {
        if (!this._isEnabled(portletDataContext)) {
            return;
        }
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(portletDataContext.getCompanyId());
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this._importGeneratedMedia(portletDataContext, fileEntry, importedFileEntry, amImageConfigurationEntry);
        }
    }

    private void _exportConfigurationEntry(PortletDataContext portletDataContext, AMImageConfigurationEntry amImageConfigurationEntry) {
        portletDataContext.addZipEntry(this._getConfigurationEntryBinPath(amImageConfigurationEntry), this._amImageConfigurationEntrySerializer.serialize(amImageConfigurationEntry));
    }

    private void _exportMedia(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        List adaptiveMedias = this._amImageFinder.getAdaptiveMedias(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).done());
        for (AdaptiveMedia adaptiveMedia : adaptiveMedias) {
            this._exportMedia(portletDataContext, fileEntry, (AdaptiveMedia<AMProcessor<FileVersion>>)adaptiveMedia);
        }
    }

    private void _exportMedia(PortletDataContext portletDataContext, FileEntry fileEntry, AdaptiveMedia<AMProcessor<FileVersion>> adaptiveMedia) throws Exception {
        String configurationUuid = (String)adaptiveMedia.getValue(AMAttribute.getConfigurationUuidAMAttribute());
        if (configurationUuid == null) {
            return;
        }
        String basePath = this._getAMBasePath(fileEntry, configurationUuid);
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            try (InputStream inputStream = adaptiveMedia.getInputStream();){
                portletDataContext.addZipEntry(basePath + ".bin", inputStream);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find adaptive media for file entry ", fileEntry.getFileEntryId(), " and configuration ", configurationUuid}), (Throwable)exception);
                }
                return;
            }
        }
        portletDataContext.addZipEntry(basePath + ".json", this._amImageSerializer.serialize(adaptiveMedia));
    }

    private List<AdaptiveMedia<AMProcessor<FileVersion>>> _getAdaptiveMedias(FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            FileVersion fileVersion = fileEntry.getFileVersion();
            return this._amImageFinder.getAdaptiveMedias(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).forConfiguration(amImageConfigurationEntry.getUUID()).done());
        }
        catch (PortalException portalException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to find adaptive media for file entry ", fileEntry.getFileEntryId(), " and configuration ", amImageConfigurationEntry.getUUID()}), (Throwable)portalException);
            return Collections.emptyList();
        }
    }

    private String _getAMBasePath(FileEntry fileEntry, String uuid) {
        return String.format("adaptive-media/%s/%s/%s", FileEntry.class.getSimpleName(), fileEntry.getUuid(), uuid);
    }

    private String _getConfigurationEntryBinPath(AMImageConfigurationEntry amImageConfigurationEntry) {
        return String.format("adaptive-media/%s.cf", amImageConfigurationEntry.getUUID());
    }

    private AdaptiveMedia<AMProcessor<FileVersion>> _getExportedMedia(PortletDataContext portletDataContext, FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        String basePath = this._getAMBasePath(fileEntry, amImageConfigurationEntry.getUUID());
        String serializedAdaptiveMedia = portletDataContext.getZipEntryAsString(basePath + ".json");
        if (serializedAdaptiveMedia == null) {
            return null;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            return this._amImageSerializer.deserialize(serializedAdaptiveMedia, () -> portletDataContext.getZipEntryAsInputStream(basePath + ".bin"));
        }
        List<AdaptiveMedia<AMProcessor<FileVersion>>> adaptiveMedias = this._getAdaptiveMedias(fileEntry, amImageConfigurationEntry);
        if (adaptiveMedias.isEmpty()) {
            return null;
        }
        AdaptiveMedia<AMProcessor<FileVersion>> adaptiveMedia = adaptiveMedias.get(0);
        return this._amImageSerializer.deserialize(serializedAdaptiveMedia, () -> adaptiveMedia.getInputStream());
    }

    private void _importGeneratedMedia(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, AMImageConfigurationEntry amImageConfigurationEntry) throws Exception {
        String configuration = portletDataContext.getZipEntryAsString(this._getConfigurationEntryBinPath(amImageConfigurationEntry));
        if (configuration == null) {
            return;
        }
        AMImageConfigurationEntry importedAMImageConfigurationEntry = this._amImageConfigurationEntrySerializer.deserialize(configuration);
        if (!importedAMImageConfigurationEntry.equals(amImageConfigurationEntry)) {
            return;
        }
        AdaptiveMedia<AMProcessor<FileVersion>> adaptiveMedia = this._getExportedMedia(portletDataContext, fileEntry, amImageConfigurationEntry);
        if (adaptiveMedia == null) {
            return;
        }
        Long contentLength = (Long)adaptiveMedia.getValue(AMAttribute.getContentLengthAMAttribute());
        Integer width = (Integer)adaptiveMedia.getValue(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
        Integer height = (Integer)adaptiveMedia.getValue(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT);
        if (contentLength == null || width == null || height == null) {
            return;
        }
        FileVersion importedFileVersion = importedFileEntry.getFileVersion();
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), importedFileVersion.getFileVersionId());
        if (amImageEntry != null) {
            this._amImageEntryLocalService.deleteAMImageEntryFileVersion(amImageConfigurationEntry.getUUID(), importedFileVersion.getFileVersionId());
        }
        try (InputStream inputStream = adaptiveMedia.getInputStream();){
            this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, importedFileVersion, height.intValue(), width.intValue(), inputStream, contentLength.longValue());
        }
    }

    private boolean _isEnabled(PortletDataContext portletDataContext) {
        return portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails");
    }
}

