/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal;

import com.liferay.adaptive.media.content.transformer.BaseRegexStringContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerContentType;
import com.liferay.adaptive.media.content.transformer.constants.ContentTransformerContentTypes;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.transformer.content.type=html"}, service={ContentTransformer.class})
public class AMBackwardsCompatibilityHtmlContentTransformer
extends BaseRegexStringContentTransformer {
    private static final Pattern _pattern = Pattern.compile("<img\\s+(?:[^>]*\\s)*src=['\"](?:/?[^\\s]*)/documents/(\\d+)/(\\d+)/([^/?]+)(?:/([-0-9a-fA-F]+))?(?:\\?t=\\d+)?['\"][^>]*/>");
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public ContentTransformerContentType<String> getContentTransformerContentType() {
        return ContentTransformerContentTypes.HTML;
    }

    public String transform(String html) throws PortalException {
        if (html == null) {
            return null;
        }
        if (!html.contains("<img") || !html.contains("/documents/")) {
            return html;
        }
        return super.transform(html);
    }

    protected FileEntry getFileEntry(Matcher matcher) throws PortalException {
        String imgTag = matcher.group(0);
        if (imgTag.contains("data-fileentryid")) {
            return null;
        }
        if (matcher.group(4) != null) {
            long groupId = Long.valueOf(matcher.group(1));
            String uuid = matcher.group(4);
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        long groupId = Long.valueOf(matcher.group(1));
        long folderId = Long.valueOf(matcher.group(2));
        String title = matcher.group(3);
        return this._dlAppLocalService.getFileEntry(groupId, folderId, title);
    }

    protected Pattern getPattern() {
        return _pattern;
    }

    protected String getReplacement(String originalImgTag, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null) {
            return originalImgTag;
        }
        return this._amImageHTMLTagFactory.create(originalImgTag, fileEntry);
    }
}

