/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.content.transformer.backwards.compatibility.internal;

import com.liferay.adaptive.media.content.transformer.BaseRegexStringContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerContentType;
import com.liferay.adaptive.media.content.transformer.constants.ContentTransformerContentTypes;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.transformer.content.type=html"}, service={ContentTransformer.class})
public class AMBackwardsCompatibilityHtmlContentTransformer
extends BaseRegexStringContentTransformer {
    private static final Log _log = LogFactoryUtil.getLog(AMBackwardsCompatibilityHtmlContentTransformer.class);
    private static final Pattern _pattern = Pattern.compile("(?:/?[^\\s]*)/documents/(\\d+)/(\\d+)/([^/?]+)(?:/([-0-9a-fA-F]+))?(?:\\?t=\\d+)?");
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public ContentTransformerContentType<String> getContentTransformerContentType() {
        return ContentTransformerContentTypes.HTML;
    }

    public String transform(String html) throws PortalException {
        if (html == null) {
            return null;
        }
        if (!html.contains("<img") || !html.contains("/documents/")) {
            return html;
        }
        Document document = this._parseDocument(html);
        for (Element imgElement : document.select("img:not(picture > img)")) {
            String imgElementString = imgElement.toString();
            String replacement = this._transform(imgElementString, imgElement.attr("src"));
            imgElement.replaceWith(this._parseNode(replacement));
        }
        Element body = document.body();
        return body.html();
    }

    protected FileEntry getFileEntry(Matcher matcher) throws PortalException {
        if (matcher.group(4) != null) {
            long groupId = Long.valueOf(matcher.group(1));
            String uuid = matcher.group(4);
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        long groupId = Long.valueOf(matcher.group(1));
        long folderId = Long.valueOf(matcher.group(2));
        String title = matcher.group(3);
        try {
            return this._dlAppLocalService.getFileEntry(groupId, folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return this._dlAppLocalService.getFileEntryByFileName(groupId, folderId, title);
        }
    }

    protected Pattern getPattern() {
        return _pattern;
    }

    protected String getReplacement(String originalImgTag, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null) {
            return originalImgTag;
        }
        return this._amImageHTMLTagFactory.create(originalImgTag, fileEntry);
    }

    private Document _parseDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        return document;
    }

    private Node _parseNode(String tag) {
        Document document = this._parseDocument(tag);
        Element bodyNode = document.body();
        return bodyNode.childNode(0);
    }

    private String _transform(String imgElementString, String src) throws PortalException {
        String replacement = imgElementString;
        StringBuffer sb = null;
        Pattern pattern = this.getPattern();
        Matcher matcher = pattern.matcher(src);
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer(imgElementString.length());
            }
            FileEntry fileEntry = null;
            if (!imgElementString.contains("data-fileentryid")) {
                fileEntry = this.getFileEntry(matcher);
            }
            replacement = this.getReplacement(imgElementString, fileEntry);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        if (sb != null) {
            matcher.appendTail(sb);
            replacement = sb.toString();
        }
        return replacement;
    }
}

