/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.heif;

import com.drew.imaging.heif.HeifHandler;
import com.drew.lang.StreamReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.heif.boxes.Box;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;

public class HeifReader {
    public void extract(Metadata metadata, InputStream inputStream, HeifHandler handler) throws IOException, DataFormatException {
        StreamReader reader = new StreamReader(inputStream);
        reader.setMotorolaByteOrder(true);
        this.processBoxes(reader, -1L, handler);
    }

    private void processBoxes(StreamReader reader, long atomEnd, HeifHandler handler) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Box box = new Box(reader);
                if (handler.shouldAcceptContainer(box)) {
                    handler.processContainer(box, reader);
                    this.processBoxes(reader, box.size + reader.getPosition() - 8L, handler);
                    continue;
                }
                if (handler.shouldAcceptBox(box)) {
                    handler = handler.processBox(box, reader.getBytes((int)box.size - 8));
                    continue;
                }
                if (box.size > 1L) {
                    reader.skip(box.size - 8L);
                    continue;
                }
                if (box.size != -1L) continue;
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

