/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.util;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ImageResolutionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class RenderedImageUtil {
    private static final Log _log = LogFactoryUtil.getLog(RenderedImageUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getRenderedImageContentStream(RenderedImage renderedImage, String mimeType) {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            ImageToolUtil.write((RenderedImage)renderedImage, (String)mimeType, (OutputStream)unsyncByteArrayOutputStream);
            byte[] byArray = unsyncByteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException ioException) {
            throw new AMRuntimeException.IOException((Throwable)ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage readImage(InputStream inputStream) throws IOException, PortalException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        while (iterator.hasNext()) {
            ImageReader imageReader = null;
            try {
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                int height = imageReader.getHeight(0);
                int width = imageReader.getWidth(0);
                if (PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT > 0L && (long)height > PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT || PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH > 0L && (long)width > PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH) {
                    throw new ImageResolutionException(StringBundler.concat((Object[])new Object[]{"Image's dimensions of ", height, " px high and ", width, " px wide exceed max dimensions of ", PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT, " px high and ", PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH, " px wide"}));
                }
                BufferedImage bufferedImage = imageReader.read(0);
                return bufferedImage;
            }
            catch (ImageResolutionException imageResolutionException) {
                throw imageResolutionException;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception, (Throwable)exception);
            }
            finally {
                if (imageReader == null) continue;
                imageReader.dispose();
            }
        }
        throw new IOException("Unsupported image type");
    }
}

