/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.item.selector.internal;

import com.liferay.adaptive.media.image.item.selector.AMImageURLItemSelectorReturnType;
import com.liferay.adaptive.media.image.media.query.Condition;
import com.liferay.adaptive.media.image.media.query.MediaQuery;
import com.liferay.adaptive.media.image.media.query.MediaQueryProvider;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.item.selector.ItemSelectorReturnTypeResolver;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={ItemSelectorReturnTypeResolver.class})
public class FileEntryAMImageURLItemSelectorReturnTypeResolver
implements ItemSelectorReturnTypeResolver<AMImageURLItemSelectorReturnType, FileEntry> {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private MediaQueryProvider _mediaQueryProvider;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public Class<AMImageURLItemSelectorReturnType> getItemSelectorReturnTypeClass() {
        return AMImageURLItemSelectorReturnType.class;
    }

    public Class<FileEntry> getModelClass() {
        return FileEntry.class;
    }

    public String getValue(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        String previewURL = null;
        previewURL = fileEntry.getGroupId() == fileEntry.getRepositoryId() ? this._dlURLHelper.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay, "", false, false) : this._portletFileRepository.getPortletFileEntryURL(themeDisplay, fileEntry, "&imagePreview=1", false);
        JSONObject fileEntryJSONObject = JSONUtil.put((String)"defaultSource", (Object)previewURL).put("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        JSONArray sourcesJSONArray = JSONFactoryUtil.createJSONArray();
        List mediaQueries = this._mediaQueryProvider.getMediaQueries(fileEntry);
        Stream mediaQueryStream = mediaQueries.stream();
        mediaQueryStream.map(this::_getSourceJSONObject).forEach(arg_0 -> ((JSONArray)sourcesJSONArray).put(arg_0));
        fileEntryJSONObject.put("sources", sourcesJSONArray);
        return fileEntryJSONObject.toString();
    }

    private JSONObject _getSourceJSONObject(MediaQuery mediaQuery) {
        JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
        for (Condition condition : mediaQuery.getConditions()) {
            attributesJSONObject.put(condition.getAttribute(), condition.getValue());
        }
        return JSONUtil.put((String)"attributes", (Object)attributesJSONObject).put("src", mediaQuery.getSrc());
    }
}

