/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.storage;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.internal.storage.AMStoreUtil;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ImageStorage.class})
public class ImageStorage {
    @Reference(target="(default=true)")
    private Store _store;

    public void delete(FileVersion fileVersion, String configurationUuid) {
        this._store.deleteDirectory(fileVersion.getCompanyId(), 0L, AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid));
    }

    public void delete(long companyId, String configurationUuid) {
        this._store.deleteDirectory(companyId, 0L, this.getConfigurationEntryPath(configurationUuid));
    }

    public InputStream getContentInputStream(FileVersion fileVersion, String configurationUuid) {
        try {
            String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid);
            return this._store.getFileAsStream(fileVersion.getCompanyId(), 0L, fileVersionPath, "1.0");
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException.IOException((Throwable)portalException);
        }
    }

    public boolean hasContent(FileVersion fileVersion, String configurationUuid) {
        String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid);
        return this._store.hasFile(fileVersion.getCompanyId(), 0L, fileVersionPath, "1.0");
    }

    public void save(FileVersion fileVersion, String configurationUuid, InputStream inputStream) {
        try {
            String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid);
            this._store.addFile(fileVersion.getCompanyId(), 0L, fileVersionPath, "1.0", inputStream);
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException.IOException((Throwable)portalException);
        }
    }

    protected String getConfigurationEntryPath(String configurationUuid) {
        return String.format("adaptive/%s", configurationUuid);
    }

    protected void setStore(Store store) {
        this._store = store;
    }
}

