/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.service.impl;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.exception.DuplicateAMImageEntryException;
import com.liferay.adaptive.media.image.internal.storage.ImageStorage;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.service.base.AMImageEntryLocalServiceBaseImpl;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.adaptive.media.image.model.AMImageEntry"}, service={AopService.class})
public class AMImageEntryLocalServiceImpl
extends AMImageEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AMImageEntryLocalServiceImpl.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private ImageStorage _imageStorage;
    private ServiceTrackerMap<String, AMImageCounter> _serviceTrackerMap;

    public AMImageEntry addAMImageEntry(AMImageConfigurationEntry amImageConfigurationEntry, FileVersion fileVersion, int height, int width, InputStream inputStream, long size) throws PortalException {
        this._checkDuplicateAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
        long imageEntryId = this.counterLocalService.increment();
        AMImageEntry amImageEntry = this.amImageEntryPersistence.create(imageEntryId);
        amImageEntry.setGroupId(fileVersion.getGroupId());
        amImageEntry.setCompanyId(fileVersion.getCompanyId());
        amImageEntry.setCreateDate(new Date());
        amImageEntry.setConfigurationUuid(amImageConfigurationEntry.getUUID());
        amImageEntry.setFileVersionId(fileVersion.getFileVersionId());
        amImageEntry.setMimeType(fileVersion.getMimeType());
        amImageEntry.setHeight(height);
        amImageEntry.setWidth(width);
        amImageEntry.setSize(size);
        this._imageStorage.save(fileVersion, amImageConfigurationEntry.getUUID(), inputStream);
        return (AMImageEntry)this.amImageEntryPersistence.update((BaseModel)amImageEntry);
    }

    public void deleteAMImageEntries(long companyId, AMImageConfigurationEntry amImageConfigurationEntry) {
        this.amImageEntryPersistence.removeByC_C(companyId, amImageConfigurationEntry.getUUID());
        this._imageStorage.delete(companyId, amImageConfigurationEntry.getUUID());
    }

    public void deleteAMImageEntryFileVersion(FileVersion fileVersion) throws PortalException {
        List amImageEntries = this.amImageEntryPersistence.findByFileVersionId(fileVersion.getFileVersionId());
        for (AMImageEntry amImageEntry : amImageEntries) {
            try {
                this.amImageEntryPersistence.remove((BaseModel)amImageEntry);
                this._imageStorage.delete(fileVersion, amImageEntry.getConfigurationUuid());
            }
            catch (AMRuntimeException.IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
    }

    public void deleteAMImageEntryFileVersion(String configurationUuid, long fileVersionId) throws PortalException {
        FileVersion fileVersion = this._dlAppLocalService.getFileVersion(fileVersionId);
        AMImageEntry amImageEntry = this.amImageEntryPersistence.findByC_F(configurationUuid, fileVersionId);
        this.amImageEntryPersistence.remove((BaseModel)amImageEntry);
        this._imageStorage.delete(fileVersion, amImageEntry.getConfigurationUuid());
    }

    public AMImageEntry fetchAMImageEntry(String configurationUuid, long fileVersionId) {
        return this.amImageEntryPersistence.fetchByC_F(configurationUuid, fileVersionId);
    }

    public List<AMImageEntry> getAMImageEntries(long fileVersionId) {
        return this.amImageEntryPersistence.findByFileVersionId(fileVersionId);
    }

    public int getAMImageEntriesCount(long companyId, String configurationUuid) {
        return this.amImageEntryPersistence.countByC_C(companyId, configurationUuid);
    }

    public InputStream getAMImageEntryContentStream(AMImageConfigurationEntry amImageConfigurationEntry, FileVersion fileVersion) {
        return this._imageStorage.getContentInputStream(fileVersion, amImageConfigurationEntry.getUUID());
    }

    public int getExpectedAMImageEntriesCount(long companyId) {
        int count = 0;
        for (AMImageCounter amImageCounter : this._serviceTrackerMap.values()) {
            count += amImageCounter.countExpectedAMImageEntries(companyId);
        }
        return count;
    }

    public int getPercentage(long companyId, String configurationUuid) {
        int expectedAMImageEntriesCount = this.getExpectedAMImageEntriesCount(companyId);
        if (expectedAMImageEntriesCount == 0) {
            return 0;
        }
        int actualAMImageEntriesCount = this.getAMImageEntriesCount(companyId, configurationUuid);
        int percentage = actualAMImageEntriesCount * 100 / expectedAMImageEntriesCount;
        return Math.min(percentage, 100);
    }

    public boolean hasAMImageEntryContent(String configurationUuid, FileVersion fileVersion) {
        return this._imageStorage.hasContent(fileVersion, configurationUuid);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AMImageCounter.class, (String)"adaptive.media.key");
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._serviceTrackerMap.close();
    }

    private void _checkDuplicateAMImageEntry(String configurationUuid, long fileVersionId) throws DuplicateAMImageEntryException {
        AMImageEntry amImageEntry = this.amImageEntryPersistence.fetchByC_F(configurationUuid, fileVersionId);
        if (amImageEntry != null) {
            throw new DuplicateAMImageEntryException();
        }
    }
}

