/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.upload.internal.web.attachment;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.upload.AttachmentElementReplacer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"format=html", "html.tag.name=img", "service.ranking:Integer=2"}, service={AttachmentElementReplacer.class})
public class AMHTMLImageAttachmentElementReplacer
implements AttachmentElementReplacer {
    @Reference(target="(&(format=html)(html.tag.name=img)(!(component.name=com.liferay.adaptive.media.upload.internal.web.attachment.AMHTMLImageAttachmentElementReplacer)))")
    private AttachmentElementReplacer _defaultAttachmentElementReplacer;

    public AMHTMLImageAttachmentElementReplacer() {
    }

    public String replace(String originalElement, FileEntry fileEntry) {
        Element imageElement = this._parseImgTag(this._defaultAttachmentElementReplacer.replace(originalElement, fileEntry));
        imageElement.attr("data-fileentryid", String.valueOf(fileEntry.getFileEntryId()));
        return imageElement.toString();
    }

    protected AMHTMLImageAttachmentElementReplacer(AttachmentElementReplacer defaultAttachmentElementReplacer) {
        this._defaultAttachmentElementReplacer = defaultAttachmentElementReplacer;
    }

    private Element _parseImgTag(String originalImgTag) {
        Document document = Jsoup.parseBodyFragment((String)originalImgTag);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        Element element = document.body();
        return element.child(0);
    }
}

