Liferay.Loader.define("adaptive-media-web@4.0.48/adaptive_media/js/AdaptiveMediaProgress.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/progress-bar', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './utils/entryIcons.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _progressBar = _interopRequireDefault(require("@frontend-taglib-clay$clayui/progress-bar"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _entryIcons = require("./utils/entryIcons.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var AdaptiveMediaProgress = function AdaptiveMediaProgress(_ref) {
      var adaptedImages = _ref.adaptedImages,
          adaptiveMediaProgressComponentId = _ref.adaptiveMediaProgressComponentId,
          _ref$autoStartProgres = _ref.autoStartProgress,
          autoStartProgress = _ref$autoStartProgres === void 0 ? false : _ref$autoStartProgres,
          _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? false : _ref$disabled,
          _ref$intervalSpeed = _ref.intervalSpeed,
          intervalSpeed = _ref$intervalSpeed === void 0 ? 1000 : _ref$intervalSpeed,
          namespace = _ref.namespace,
          percentageUrl = _ref.percentageUrl,
          tooltip = _ref.tooltip,
          totalImages = _ref.totalImages,
          uuid = _ref.uuid;
      var delay = (0, _frontendJsReactWeb.useTimeout)();
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var _useState = (0, _react.useState)(autoStartProgress),
          _useState2 = _slicedToArray(_useState, 2),
          showLoadingIndicator = _useState2[0],
          setShowLoadingIndicator = _useState2[1];

      var _useState3 = (0, _react.useState)(Math.ceil(adaptedImages / totalImages * 100) || 0),
          _useState4 = _slicedToArray(_useState3, 2),
          percentage = _useState4[0],
          setPercentage = _useState4[1];

      var _useState5 = (0, _react.useState)(adaptedImages + '/' + totalImages),
          _useState6 = _slicedToArray(_useState5, 2),
          progressBarTooltip = _useState6[0],
          setProgressBarTooltip = _useState6[1];

      var _useState7 = (0, _react.useState)(0),
          _useState8 = _slicedToArray(_useState7, 2),
          imagesFailed = _useState8[0],
          setImagesFailed = _useState8[1];

      var updateProgress = (0, _react.useCallback)(function () {
        (0, _frontendJsWeb.fetch)(percentageUrl).then(function (res) {
          return res.json();
        }).then(function (_ref2) {
          var adaptedImages = _ref2.adaptedImages,
              errors = _ref2.errors,
              totalImages = _ref2.totalImages;

          if (isMounted()) {
            setImagesFailed(errors);
            setPercentage(Math.ceil(adaptedImages / totalImages * 100) || 0);
            setProgressBarTooltip(tooltip ? tooltip : adaptedImages + '/' + totalImages);
          }

          if (adaptedImages + errors === totalImages) {
            if (isMounted()) {
              setShowLoadingIndicator(false);
            }

            (0, _entryIcons.enableEntryIcon)(document.getElementById("".concat(namespace, "icon-disable-").concat(uuid)));
          } else {
            delay(updateProgress, intervalSpeed);
          }
        });
      }, [delay, intervalSpeed, isMounted, namespace, percentageUrl, tooltip, uuid]);
      var startProgress = (0, _react.useCallback)(function (backgroundTaskUrl) {
        (0, _frontendJsWeb.fetch)(backgroundTaskUrl);

        if (isMounted()) {
          setShowLoadingIndicator(true);
        }

        (0, _entryIcons.disableEntryIcon)(document.getElementById("".concat(namespace, "icon-adapt-remaining").concat(uuid)));
        (0, _entryIcons.disableEntryIcon)(document.getElementById("".concat(namespace, "icon-disable-").concat(uuid)));
        return delay(updateProgress, intervalSpeed);
      }, [delay, intervalSpeed, isMounted, namespace, updateProgress, uuid]);

      (0, _react.useEffect)(function () {
        if (autoStartProgress) {
          updateProgress();
        }
      }, [autoStartProgress, updateProgress]);

      if (!Liferay.component(adaptiveMediaProgressComponentId)) {
        Liferay.component(adaptiveMediaProgressComponentId, {
          startProgress: startProgress
        }, {
          destroyOnNavigate: true
        });
      }

      return imagesFailed > 0 ? /*#__PURE__*/_react.default.createElement("div", {
        className: "progress-error-container"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "text-danger"
      }, /*#__PURE__*/_react.default.createElement(_icon.default, {
        symbol: "exclamation-full"
      }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, Liferay.Language.get('error'), ": "), imagesFailed === 1 ? Liferay.Language.get('1-image-failed-process') : Liferay.Util.sub(Liferay.Language.get('x-images-failed-process'), imagesFailed))), /*#__PURE__*/_react.default.createElement(_button.default, {
        borderless: true,
        className: "text-danger",
        onClick: function onClickRetry() {
          setImagesFailed(0);
          startProgress();
        },
        small: true
      }, Liferay.Language.get('retry'))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "progress-container ".concat(disabled ? 'disabled' : ''),
        "data-percentage": percentage,
        "data-title": progressBarTooltip
      }, /*#__PURE__*/_react.default.createElement(_progressBar.default, {
        value: percentage
      })), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(showLoadingIndicator ? '' : 'hide ', "loading-animation loading-animation-sm")
      }));
    };

    var _default = AdaptiveMediaProgress;
    exports.default = _default;
    //# sourceMappingURL=AdaptiveMediaProgress.es.js.map
  }
});
//# sourceMappingURL=AdaptiveMediaProgress.es.js.map