Liferay.Loader.define("adaptive-media-web@4.0.48/adaptive_media/js/EditAdaptiveMediaConfig.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var VALID_INPUT_KEYS = new Set(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'ArrowDown', 'ArrowUp', 'Backspace', 'Down', 'Enter', 'Tab', 'Up']);
    /**
     * EditAdaptiveMediaConfig
     *
     * @abstract
     * @extends {PortletBase}
     */

    var EditAdaptiveMediaConfig = /*#__PURE__*/function (_PortletBase) {
      _inherits(EditAdaptiveMediaConfig, _PortletBase);

      function EditAdaptiveMediaConfig() {
        _classCallCheck(this, EditAdaptiveMediaConfig);

        return _possibleConstructorReturn(this, _getPrototypeOf(EditAdaptiveMediaConfig).apply(this, arguments));
      }

      _createClass(EditAdaptiveMediaConfig, [{
        key: "attached",

        /**
         * @inheritDoc
         */
        value: function attached() {
          var _this = this;

          var idOptions = this.one('#idOptions');

          if (idOptions) {
            _metalDom.default.delegate(idOptions, 'change', 'input[type="radio"]', function (event) {
              return _this.onChangeUuidOptions_(event.delegateTarget);
            });
          }

          var nameInput = this.one('#name');

          if (nameInput) {
            nameInput.addEventListener('input', function () {
              return _this.updateUuid();
            });
          }

          this.nameInput = nameInput;
          var maxHeightInput = this.one('#maxHeight');
          var maxWidthInput = this.one('#maxWidth');

          if (maxWidthInput) {
            maxWidthInput.addEventListener('keydown', function (event) {
              _this.handleKeyDown_(event);
            });
            maxWidthInput.addEventListener('input', function () {
              return _this.validateDimensions_();
            });
          }

          if (maxHeightInput) {
            maxHeightInput.addEventListener('keydown', function (event) {
              return _this.handleKeyDown_(event);
            });
            maxHeightInput.addEventListener('input', function () {
              return _this.validateDimensions_();
            });
          }

          this.maxHeightInput = maxHeightInput;
          this.maxWidthInput = maxWidthInput;
          this.newUuidInput = this.one('#newUuid');
          this.newUuidLabel = this.one('label', this.newUuidInput.parentNode);
          var saveButton = this.one('button[type=submit]');
          saveButton.addEventListener('click', function (event) {
            return _this.onSubmitForm_(event);
          });
        }
        /**
         * Updates the uuid identifier based on the "name" field
         * if the "Automatic" option is selected
         */

      }, {
        key: "updateUuid",
        value: function updateUuid() {
          var newUuidInput = this.newUuidInput;
          var uuidEmpty = !newUuidInput.value;

          if (this.isAutomaticUuid_() && (uuidEmpty || this._originalUuidChanged)) {
            newUuidInput.value = (0, _frontendJsWeb.normalizeFriendlyURL)(this.nameInput.value);
          }

          this._originalUuidChanged = true;
        }
        /**
         * Prevents from introducing letters in the input field.
         *
         * @param {KeyboardEvent} event The keyboard event.
         */

      }, {
        key: "handleKeyDown_",
        value: function handleKeyDown_(event) {
          if (!VALID_INPUT_KEYS.has(event.key)) {
            event.preventDefault();
          }
        }
        /**
         * Returns if the "Automatic" check is selected
         * @return {Boolean} whether the "Automatic" radiobutton is checked or not.
         */

      }, {
        key: "isAutomaticUuid_",
        value: function isAutomaticUuid_() {
          return this.one('input:checked', '#idOptions').value === 'true';
        }
        /**
         * Checks if the uuid identifier has a custom
         * value or it has to be generated automatically.
         *
         * @protected
         */

      }, {
        key: "onChangeUuidOptions_",
        value: function onChangeUuidOptions_() {
          var newUuidInput = this.newUuidInput;
          var newUuidLabel = this.newUuidLabel;

          if (this.isAutomaticUuid_()) {
            this._lastCustomUuuid = newUuidInput.value;
            this.updateUuid(this.nameInput.value);
            newUuidInput.setAttribute('disabled', true);
            newUuidLabel.classList.add('disabled');
          } else {
            newUuidInput.value = this._lastCustomUuuid || newUuidInput.value;
            newUuidInput.removeAttribute('disabled');
            newUuidLabel.classList.remove('disabled');
          }
        }
        /**
         * Checks if there are form errors before
         * submitting the AMI.
         *
         * @param {Event} event The event that
         * triggered the submit action.
         * @protected
         */

      }, {
        key: "onSubmitForm_",
        value: function onSubmitForm_(event) {
          this.validateDimensions_();
          var form = Liferay.Form.get(this.ns('fm'));
          form.formValidator.validate();

          if (form.formValidator.hasErrors()) {
            event.preventDefault();
          } else {
            submitForm(form.form);
          }
        }
        /**
         * Checks if max-widht or max-height has a value.
         *
         * @protected
         */

      }, {
        key: "validateDimensions_",
        value: function validateDimensions_() {
          var form = Liferay.Form.get(this.ns('fm'));
          var nsMaxHeight = this.ns('maxHeight');
          var nsMaxWidth = this.ns('maxWidth');
          var inputErrorMessage = Liferay.Language.get('at-least-one-value-is-required');


          if (this.maxWidthInput.value || this.maxHeightInput.value) {
            form.removeRule(nsMaxWidth, 'required');
            form.removeRule(nsMaxHeight, 'required');
          } else {
            form.addRule(nsMaxWidth, 'required', inputErrorMessage);
            form.addRule(nsMaxHeight, 'required', ' ');
            form.formValidator.validateField(nsMaxWidth);
            form.formValidator.validateField(nsMaxHeight);
          }
        }
      }]);

      return EditAdaptiveMediaConfig;
    }(_frontendJsWeb.PortletBase);
    /**
     * EditAdaptiveMediaConfig State definition.
     * @ignore
     * @static
     * @type {!Object}
     */

    EditAdaptiveMediaConfig.STATE = {
      /**
       * Node where errors will be rendered.
       * @instance
       * @memberof EditAdaptiveMediaConfig
       * @type {String}
       */
      errorNode: {
        validator: _metal.default.isString,
        value: '.error-wrapper'
      }
    };
    var _default = EditAdaptiveMediaConfig;
    exports.default = _default;
    //# sourceMappingURL=EditAdaptiveMediaConfig.es.js.map
  }
});
//# sourceMappingURL=EditAdaptiveMediaConfig.es.js.map