Liferay.Loader.define('adaptive-media-web$lodash-es@4.17.15/isSymbol', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseGetTag from './_baseGetTag.js';
    import isObjectLike from './isObjectLike.js';

    /** `Object#toString` result references. */
    var symbolTag = '[object Symbol]';

    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */
    function isSymbol(value) {
      return typeof value == 'symbol' || isObjectLike(value) && baseGetTag(value) == symbolTag;
    }

    export default isSymbol;
  }
});
//# sourceMappingURL=isSymbol.js.map