Liferay.Loader.define('adaptive-media-web$lodash-es@4.17.15/forEachRight', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayEachRight from './_arrayEachRight.js';
    import baseEachRight from './_baseEachRight.js';
    import castFunction from './_castFunction.js';
    import isArray from './isArray.js';

    /**
     * This method is like `_.forEach` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @alias eachRight
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array|Object} Returns `collection`.
     * @see _.forEach
     * @example
     *
     * _.forEachRight([1, 2], function(value) {
     *   console.log(value);
     * });
     * // => Logs `2` then `1`.
     */
    function forEachRight(collection, iteratee) {
      var func = isArray(collection) ? arrayEachRight : baseEachRight;
      return func(collection, castFunction(iteratee));
    }

    export default forEachRight;
  }
});
//# sourceMappingURL=forEachRight.js.map