/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.portal.instance.lifecycle;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class PortalInstanceLifecycleListenerImpl
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerImpl.class);
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=portal)(release.schema.version>=9.2.0))")
    private Release _release;

    public void portalInstancePreunregistered(Company company) throws Exception {
        this._countryLocalService.deleteCompanyCountries(company.getCompanyId());
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        int count = this._countryLocalService.getCompanyCountriesCount(company.getCompanyId());
        if (count > 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping country initialization. Countries are ", "already initialized for company ", company.getCompanyId(), "."}));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing countries for company " + company.getCompanyId()));
        }
        JSONArray countriesJSONArray = this._getJSONArray("com/liferay/address/dependencies/countries.json");
        for (int i = 0; i < countriesJSONArray.length(); ++i) {
            JSONObject countryJSONObject = countriesJSONArray.getJSONObject(i);
            try {
                String name = countryJSONObject.getString("name");
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(company.getCompanyId());
                User defaultUser = company.getDefaultUser();
                serviceContext.setUserId(defaultUser.getUserId());
                Country country = this._countryLocalService.addCountry(countryJSONObject.getString("a2"), countryJSONObject.getString("a3"), true, true, countryJSONObject.getString("idd"), name, countryJSONObject.getString("number"), 0.0, true, false, countryJSONObject.getBoolean("zipRequired"), serviceContext);
                this._processCountryRegions(country);
                continue;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception.getMessage());
            }
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
        super.portalInstanceUnregistered(company);
    }

    private JSONArray _getJSONArray(String path) throws Exception {
        return this._jsonFactory.createJSONArray(StringUtil.read((ClassLoader)this.getClassLoader(), (String)path, (boolean)false));
    }

    private void _processCountryRegions(Country country) {
        block8: {
            String a2 = country.getA2();
            try {
                String path = "com/liferay/address/dependencies/regions/" + a2 + ".json";
                ClassLoader classLoader = this.getClassLoader();
                if (classLoader.getResource(path) == null) {
                    return;
                }
                JSONArray regionsJSONArray = this._getJSONArray(path);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Regions found for country " + a2));
                }
                for (int i = 0; i < regionsJSONArray.length(); ++i) {
                    try {
                        JSONObject regionJSONObject = regionsJSONArray.getJSONObject(i);
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setCompanyId(country.getCompanyId());
                        serviceContext.setUserId(country.getUserId());
                        Region region = this._regionLocalService.addRegion(country.getCountryId(), true, regionJSONObject.getString("name"), 0.0, regionJSONObject.getString("regionCode"), serviceContext);
                        JSONObject localizationsJSONObject = regionJSONObject.getJSONObject("localizations");
                        if (localizationsJSONObject == null) continue;
                        for (String key : localizationsJSONObject.keySet()) {
                            this._regionLocalService.updateRegionLocalization(region, key, localizationsJSONObject.getString(key));
                        }
                        continue;
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)portalException, (Throwable)portalException);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)("No regions found for country " + a2), (Throwable)exception);
            }
        }
    }
}

