/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc.json.web.service;

import com.liferay.alloy.mvc.AlloyController;
import com.liferay.alloy.mvc.AlloyPortlet;
import com.liferay.alloy.mvc.BaseAlloyControllerImpl;
import com.liferay.alloy.mvc.internal.json.web.service.AlloyMockUtil;
import com.liferay.alloy.mvc.json.web.service.AlloyControllerInvoker;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.lang.reflect.Constructor;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public abstract class BaseAlloyControllerInvokerImpl
implements AlloyControllerInvoker {
    private AlloyPortlet _alloyPortlet;
    private String _controller;
    private Class<? extends AlloyController> _controllerClass;
    private Portlet _portlet;
    private ThemeDisplay _themeDisplay;

    @Override
    public JSONSerializable invokeAlloyController(String lifecycle, Object ... parameters) throws Exception {
        Constructor<? extends AlloyController> constructor = this._controllerClass.getConstructor(new Class[0]);
        AlloyController alloyController = constructor.newInstance(new Object[0]);
        DynamicServletRequest httpServletRequest = this.createRequest(lifecycle, parameters);
        HttpServletResponse httpServletResponse = this.createResponse();
        PageContext pageContext = this.createPageContext((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        alloyController.setPageContext(pageContext);
        alloyController.afterPropertiesSet();
        alloyController.execute();
        return this.getJSONSerializable(alloyController.getResponseContent());
    }

    @Override
    public void setProperties(ThemeDisplay themeDisplay, AlloyPortlet alloyPortlet, Portlet portlet, String controller, Class<? extends AlloyController> controllerClass) {
        this._alloyPortlet = alloyPortlet;
        this._controller = controller;
        this._controllerClass = controllerClass;
        this._portlet = portlet;
        this._themeDisplay = themeDisplay;
    }

    protected ActionRequest createActionRequest() {
        return new AlloyMockUtil.MockActionRequest();
    }

    protected ActionResponse createActionResponse() {
        return new AlloyMockUtil.MockActionResponse();
    }

    protected PageContext createPageContext(final ServletRequest servletRequest, final ServletResponse servletResponse) {
        return new AlloyMockUtil.MockPageContext(){

            @Override
            public ServletRequest getRequest() {
                return servletRequest;
            }

            @Override
            public ServletResponse getResponse() {
                return servletResponse;
            }
        };
    }

    protected RenderRequest createRenderRequest() {
        return new AlloyMockUtil.MockRenderRequest();
    }

    protected RenderResponse createRenderResponse(final HttpServletRequest httpServletRequest, final String portletId, final long plid, final String lifecycle) {
        return new AlloyMockUtil.MockRenderResponse(){
            protected String contentType;

            @Override
            public PortletURL createRenderURL() {
                return PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (long)plid, (String)lifecycle);
            }

            @Override
            public String getContentType() {
                return this.contentType;
            }

            @Override
            public void setContentType(String contentType) {
                this.contentType = contentType;
            }
        };
    }

    protected DynamicServletRequest createRequest(String lifecycle, Object ... parameters) throws Exception {
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Parameters length is not an even number");
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        final User user = UserLocalServiceUtil.getUser((long)permissionChecker.getUserId());
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)new AlloyMockUtil.MockHttpServletRequest(){

            @Override
            public Locale getLocale() {
                return user.getLocale();
            }
        });
        DynamicServletRequest request = new DynamicServletRequest((HttpServletRequest)requestWrapper, false);
        for (int i = 0; i < parameters.length; i += 2) {
            request.appendParameter(String.valueOf(parameters[i]), String.valueOf(parameters[i + 1]));
        }
        request.appendParameter("controller", this._controller);
        request.appendParameter("format", "json");
        ThemeDisplay themeDisplay = (ThemeDisplay)this._themeDisplay.clone();
        themeDisplay.setUser(user);
        request.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        request.setAttribute("LAYOUT", (Object)themeDisplay.getLayout());
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)PortletConfigFactoryUtil.create((Portlet)this._portlet, null);
        request.setAttribute("javax.portlet.config", (Object)liferayPortletConfig);
        request.setAttribute("javax.portlet.portlet", (Object)this._alloyPortlet);
        ActionRequest portletRequest = null;
        ActionResponse portletResponse = null;
        if (lifecycle.equals("ACTION_PHASE")) {
            portletRequest = this.createActionRequest();
            portletResponse = this.createActionResponse();
        } else {
            portletRequest = this.createRenderRequest();
            portletResponse = this.createRenderResponse((HttpServletRequest)request, this._portlet.getRootPortletId(), themeDisplay.getPlid(), lifecycle);
        }
        request.setAttribute("javax.portlet.request", (Object)portletRequest);
        request.setAttribute("javax.portlet.response", (Object)portletResponse);
        request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
        request.setAttribute(BaseAlloyControllerImpl.VIEW_PATH, (Object)"");
        return request;
    }

    protected HttpServletResponse createResponse() {
        return new AlloyMockUtil.MockHttpServletResponse(){
            protected String contentType;

            @Override
            public String getContentType() {
                return this.contentType;
            }

            @Override
            public void setContentType(String type) {
                this.contentType = type;
            }
        };
    }

    protected JSONSerializable getJSONSerializable(final String content) {
        return new JSONSerializable(){

            public String toJSONString() {
                return content;
            }
        };
    }
}

