/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AnalyticsEventsMessage
implements Serializable {
    private Map<String, String> _context = new HashMap<String, String>();
    private String _dataSourceId;
    private List<Event> _events = new ArrayList<Event>();
    private String _protocolVersion;
    private String _userId;

    public static Builder builder(AnalyticsEventsMessage analyticsEventsMessage) {
        return new Builder(analyticsEventsMessage);
    }

    public static Builder builder(String dataSourceId) {
        return new Builder(dataSourceId);
    }

    public static Builder builder(String dataSourceId, String userId) {
        return new Builder(dataSourceId, userId);
    }

    public Map<String, String> getContext() {
        return Collections.unmodifiableMap(this._context);
    }

    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public List<Event> getEvents() {
        return this._events;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public String getUserId() {
        return this._userId;
    }

    private AnalyticsEventsMessage() {
    }

    public static final class Event
    implements Serializable {
        private String _applicationId;
        private Date _eventDate = new Date();
        private String _eventId;
        private Map<String, String> _properties = new HashMap<String, String>();

        public static Builder builder(String applicationId, String eventId) {
            return new Builder(applicationId, eventId);
        }

        public String getApplicationId() {
            return this._applicationId;
        }

        public Date getEventDate() {
            return new Date(this._eventDate.getTime());
        }

        public String getEventId() {
            return this._eventId;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this._properties);
        }

        private Event() {
        }

        public static final class Builder {
            private final Event _event = new Event();

            public Event build() {
                return this._event;
            }

            public Builder properties(Map<String, String> properties) {
                this._event._properties = properties;
                return this;
            }

            public Builder property(String key, String value) {
                this._event._properties.put(key, value);
                return this;
            }

            protected Builder(String applicationId, String eventId) {
                this._event._applicationId = applicationId;
                this._event._eventId = eventId;
            }
        }
    }

    public static final class Builder {
        private final AnalyticsEventsMessage _analyticsEventsMessage = new AnalyticsEventsMessage();

        public AnalyticsEventsMessage build() {
            if (this._analyticsEventsMessage._events.size() == 0) {
                throw new IllegalStateException("The message should contain at least one event");
            }
            return this._analyticsEventsMessage;
        }

        public Builder context(Map<String, String> context) {
            this._analyticsEventsMessage._context = context;
            return this;
        }

        public Builder contextProperty(String key, String value) {
            this._analyticsEventsMessage._context.put(key, value);
            return this;
        }

        public Builder event(Event event) {
            this._analyticsEventsMessage._events.add(event);
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this._analyticsEventsMessage._protocolVersion = protocolVersion;
            return this;
        }

        public Builder userId(String userId) {
            this._analyticsEventsMessage._userId = userId;
            return this;
        }

        protected Builder(AnalyticsEventsMessage analyticsEventsMessage) {
            this._analyticsEventsMessage._context = analyticsEventsMessage.getContext();
            this._analyticsEventsMessage._dataSourceId = analyticsEventsMessage.getDataSourceId();
            this._analyticsEventsMessage._events = analyticsEventsMessage.getEvents();
            this._analyticsEventsMessage._protocolVersion = analyticsEventsMessage.getProtocolVersion();
            this._analyticsEventsMessage._userId = analyticsEventsMessage.getUserId();
        }

        protected Builder(String dataSourceId) {
            this._analyticsEventsMessage._dataSourceId = dataSourceId;
        }

        protected Builder(String dataSourceId, String userId) {
            this._analyticsEventsMessage._dataSourceId = dataSourceId;
            this._analyticsEventsMessage._userId = userId;
        }
    }
}

