/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.messaging;

import com.liferay.analytics.message.sender.constants.AnalyticsMessagesProcessorCommand;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/analytics_messages_processor"}, service={MessageListener.class})
public class AddAnalyticsMessagesMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(AddAnalyticsMessagesMessageListener.class);
    @Reference
    private AnalyticsConfigurationTracker _analyticsConfigurationTracker;

    protected void doReceive(Message message) {
        if (!this._analyticsConfigurationTracker.isActive()) {
            return;
        }
        AnalyticsMessagesProcessorCommand analyticsMessagesProcessorCommand = (AnalyticsMessagesProcessorCommand)message.get("command");
        if (analyticsMessagesProcessorCommand != AnalyticsMessagesProcessorCommand.ADD) {
            return;
        }
        String action = (String)message.get("action");
        EntityModelListener entityModelListener = (EntityModelListener)message.get("entityModelListener");
        List baseModels = (List)message.getPayload();
        for (BaseModel baseModel : baseModels) {
            ShardedModel shardedModel = (ShardedModel)baseModel;
            entityModelListener.addAnalyticsMessage(action, entityModelListener.getAttributeNames(shardedModel.getCompanyId()), baseModel);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Added " + baseModels.size() + " analytics messages"));
        }
    }
}

