/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.messaging;

import com.liferay.analytics.message.sender.client.AnalyticsMessageSenderClient;
import com.liferay.analytics.message.sender.constants.AnalyticsMessagesProcessorCommand;
import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/analytics_messages_processor"}, service={MessageListener.class})
public class SendAnalyticsMessagesMessageListener
extends BaseMessageListener {
    private static final int _BATCH_SIZE = 100;
    private static final Log _log = LogFactoryUtil.getLog(SendAnalyticsMessagesMessageListener.class);
    @Reference
    private AnalyticsConfigurationTracker _analyticsConfigurationTracker;
    @Reference
    private AnalyticsMessageLocalService _analyticsMessageLocalService;
    @Reference
    private AnalyticsMessageSenderClient _analyticsMessageSenderClient;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, 1, TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        if (this._skipProcess(message)) {
            return;
        }
        this._companyLocalService.forEachCompanyId(companyId -> this._process((long)companyId));
    }

    protected void doReceive(Message message, long companyId) throws Exception {
        if (this._skipProcess(message)) {
            return;
        }
        this._process(companyId);
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private void _process(long companyId) throws Exception {
        while (true) {
            List analyticsMessages;
            if ((analyticsMessages = this._analyticsMessageLocalService.getAnalyticsMessages(companyId, 0, 100)).isEmpty()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Finished processing analytics messages");
                }
                return;
            }
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            for (AnalyticsMessage analyticsMessage : analyticsMessages) {
                String json = new String(StreamUtil.toByteArray((InputStream)this._analyticsMessageLocalService.openBodyInputStream(analyticsMessage.getAnalyticsMessageId())), StandardCharsets.UTF_8);
                jsonArray.put(JSONFactoryUtil.createJSONObject((String)json));
            }
            try {
                this._analyticsMessageSenderClient.send(jsonArray.toString(), companyId);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Sent " + jsonArray.length() + " analytics messages"));
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to send analytics messages for company " + companyId), (Throwable)exception);
            }
            this._analyticsMessageLocalService.deleteAnalyticsMessages(analyticsMessages);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Deleted " + analyticsMessages.size() + " analytics messages"));
        }
    }

    private boolean _skipProcess(Message message) {
        if (!this._analyticsConfigurationTracker.isActive()) {
            return true;
        }
        AnalyticsMessagesProcessorCommand analyticsMessagesProcessorCommand = (AnalyticsMessagesProcessorCommand)message.get("command");
        return analyticsMessagesProcessorCommand != null && analyticsMessagesProcessorCommand != AnalyticsMessagesProcessorCommand.SEND;
    }
}

