/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.model.listener;

import com.liferay.analytics.message.sender.model.listener.BaseEntityModelListener;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EntityModelListener.class, ModelListener.class})
public class ExpandoRowModelListener
extends BaseEntityModelListener<ExpandoRow> {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public List<String> getAttributeNames(long companyId) {
        return Collections.singletonList("modifiedDate");
    }

    protected ExpandoRow getModel(long id) throws Exception {
        return this._expandoRowLocalService.getExpandoRow(id);
    }

    protected String getPrimaryKeyName() {
        return "classPK";
    }

    protected boolean isExcluded(ExpandoRow expandoRow) {
        if (this.isCustomField(Organization.class.getName(), expandoRow.getTableId())) {
            return false;
        }
        if (this.isCustomField(User.class.getName(), expandoRow.getTableId())) {
            User user = this.userLocalService.fetchUser(expandoRow.getClassPK());
            return this.isUserExcluded(user);
        }
        return true;
    }

    protected JSONObject serialize(BaseModel<?> baseModel, List<String> includeAttributeNames) {
        User user;
        ExpandoRow expandoRow = (ExpandoRow)baseModel;
        if (this.isCustomField(Organization.class.getName(), expandoRow.getTableId())) {
            Organization organization = this._organizationLocalService.fetchOrganization(expandoRow.getClassPK());
            if (organization != null) {
                JSONObject jsonObject = super.serialize((BaseModel)organization, this.getOrganizationAttributeNames());
                jsonObject.remove(this.getPrimaryKeyName());
                return jsonObject.put("organizationId", (Object)organization.getPrimaryKeyObj());
            }
        } else if (this.isCustomField(User.class.getName(), expandoRow.getTableId()) && (user = this.userLocalService.fetchUser(expandoRow.getClassPK())) != null) {
            JSONObject jsonObject = super.serialize((BaseModel)user, this.getUserAttributeNames(user.getCompanyId()));
            jsonObject.remove(this.getPrimaryKeyName());
            return jsonObject.put("userId", (Object)user.getPrimaryKeyObj());
        }
        return JSONFactoryUtil.createJSONObject();
    }
}

