/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.oauth2.internal;

import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class AnalyticsOAuth2Activator {
    private static final String _APPLICATION_NAME = "Analytics Cloud";
    private static final String _SAP_ENTRY_NAME = "OAUTH2_preferences.write";
    private static final Pattern _baseIdPattern = Pattern.compile("(.{8})(.{4})(.{4})(.{4})(.*)");
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate() throws Exception {
        long companyId = this._portal.getDefaultCompanyId();
        if (this._hasOAuth2Application(companyId)) {
            return;
        }
        User user = this._userLocalService.getDefaultUser(companyId);
        this._addSAPEntry(companyId, user.getUserId());
        ClientProfile clientProfile = ClientProfile.WEB_APPLICATION;
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.addOAuth2Application(companyId, user.getUserId(), user.getScreenName(), new ArrayList(clientProfile.grantTypes()), AnalyticsOAuth2Activator._generateRandomId(), clientProfile.id(), AnalyticsOAuth2Activator._generateRandomSecret(), null, Collections.singletonList("token_introspection"), "https://analytics.liferay.com", 0L, _APPLICATION_NAME, null, Collections.singletonList("https://analytics.liferay.com/oauth/receive"), Arrays.asList("everything.read", "preferences.write"), new ServiceContext());
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("dependencies/logo.png");
        this._oAuth2ApplicationLocalService.updateIcon(oAuth2Application.getOAuth2ApplicationId(), inputStream);
    }

    private static String _generateRandomId() {
        String randomSecret = AnalyticsOAuth2Activator._generateRandomSecret();
        return StringUtil.replace((String)randomSecret, (String)"secret-", (String)"id-");
    }

    private static String _generateRandomSecret() {
        int size = 16;
        int count = (int)Math.ceil((double)size / 8.0);
        byte[] buffer = new byte[count * 8];
        for (int i = 0; i < count; ++i) {
            BigEndianCodec.putLong((byte[])buffer, (int)(i * 8), (long)SecureRandomUtil.nextLong());
        }
        StringBundler sb = new StringBundler(size);
        for (int i = 0; i < size; ++i) {
            sb.append(Integer.toHexString(0xFF & buffer[i]));
        }
        Matcher matcher = _baseIdPattern.matcher(sb.toString());
        return matcher.replaceFirst("secret-$1-$2-$3-$4-$5");
    }

    private void _addSAPEntry(long companyId, long userId) throws PortalException {
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, _SAP_ENTRY_NAME);
        if (sapEntry != null) {
            return;
        }
        String allowedServiceSignatures = CompanyService.class.getName() + "#updatePreferences";
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(LocaleUtil.getDefault(), "create/update/delete preferences on your behalf");
        this._sapEntryLocalService.addSAPEntry(userId, allowedServiceSignatures, false, true, _SAP_ENTRY_NAME, titleMap, new ServiceContext());
    }

    private boolean _hasOAuth2Application(long companyId) {
        DynamicQuery dynamicQuery = this._oAuth2ApplicationLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property nameProperty = PropertyFactoryUtil.forName((String)"name");
        dynamicQuery.add(nameProperty.eq((Object)_APPLICATION_NAME));
        return this._oAuth2ApplicationLocalService.dynamicQueryCount(dynamicQuery) > 0L;
    }
}

