/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.internal.configuration;

import com.liferay.analytics.message.sender.constants.AnalyticsMessagesProcessorCommand;
import com.liferay.analytics.message.sender.model.AnalyticsMessage;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.analytics.settings.internal.model.AnalyticsUserImpl;
import com.liferay.analytics.settings.internal.util.EntityModelListenerTracker;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.analytics.settings.configuration.AnalyticsConfiguration"}, immediate=true, property={"service.pid=com.liferay.analytics.settings.configuration.AnalyticsConfiguration.scoped"}, service={AnalyticsConfigurationTracker.class, ManagedServiceFactory.class})
public class AnalyticsConfigurationTrackerImpl
implements AnalyticsConfigurationTracker,
ManagedServiceFactory {
    private static final int _DEFAULT_DELTA = 500;
    private static final String[] _SAP_ENTRY_OBJECT = new String[]{"ANALYTICS_CLOUD_TOKEN", StringBundler.concat((String[])new String[]{"com.liferay.segments.asah.rest.internal.resource.v1_0.", "ExperimentResourceImpl#deleteExperiment\n", "com.liferay.segments.asah.rest.internal.resource.v1_0.", "ExperimentRunResourceImpl#postExperimentRun\n", "com.liferay.segments.asah.rest.internal.resource.v1_0.", "StatusResourceImpl#postExperimentStatus"})};
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsConfigurationTrackerImpl.class);
    private static final Map<String, String> _defaultFieldNames = HashMapBuilder.put((Object)"accountId", (Object)"Integer").put((Object)"agreedToTermsOfUse", (Object)"boolean").put((Object)"birthday", (Object)"date").put((Object)"classNameId", (Object)"Integer").put((Object)"classPK", (Object)"Integer").put((Object)"comments", (Object)"Text").put((Object)"companyId", (Object)"Integer").put((Object)"contactId", (Object)"Integer").put((Object)"createDate", (Object)"date").put((Object)"defaultUser", (Object)"boolean").put((Object)"emailAddress", (Object)"Text").put((Object)"emailAddressVerified", (Object)"boolean").put((Object)"employeeNumber", (Object)"Text").put((Object)"employeeStatusId", (Object)"Text").put((Object)"externalReferenceCode", (Object)"Text").put((Object)"facebookId", (Object)"Integer").put((Object)"facebookSn", (Object)"Text").put((Object)"firstName", (Object)"Text").put((Object)"googleUserId", (Object)"Text").put((Object)"greeting", (Object)"Text").put((Object)"hoursOfOperation", (Object)"Text").put((Object)"jabberSn", (Object)"Text").put((Object)"jobClass", (Object)"Text").put((Object)"jobTitle", (Object)"Text").put((Object)"languageId", (Object)"Text").put((Object)"lastName", (Object)"Text").put((Object)"ldapServerId", (Object)"Integer").put((Object)"male", (Object)"boolean").put((Object)"middleName", (Object)"Text").put((Object)"modifiedDate", (Object)"date").put((Object)"openId", (Object)"Text").put((Object)"parentContactId", (Object)"Integer").put((Object)"portraitId", (Object)"Integer").put((Object)"prefixId", (Object)"Integer").put((Object)"screenName", (Object)"Text").put((Object)"skypeSn", (Object)"Text").put((Object)"smsSn", (Object)"Text").put((Object)"status", (Object)"Integer").put((Object)"suffixId", (Object)"Integer").put((Object)"timeZoneId", (Object)"Text").put((Object)"twitterSn", (Object)"Text").put((Object)"userId", (Object)"Integer").put((Object)"userName", (Object)"Text").put((Object)"uuid", (Object)"Text").build();
    private boolean _active;
    private final Map<Long, AnalyticsConfiguration> _analyticsConfigurations = new ConcurrentHashMap<Long, AnalyticsConfiguration>();
    @Reference
    private AnalyticsMessageLocalService _analyticsMessageLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private EntityModelListenerTracker _entityModelListenerTracker;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    private final Set<Long> _initializedCompanyIds = new HashSet<Long>();
    @Reference
    private MessageBus _messageBus;
    private final Map<String, Long> _pidCompanyIdMapping = new ConcurrentHashMap<String, Long>();
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private volatile AnalyticsConfiguration _systemAnalyticsConfiguration;
    @Reference
    private UserLocalService _userLocalService;

    public void deleted(String pid) {
        long companyId = this.getCompanyId(pid);
        this._unmapPid(pid);
        this._disable(companyId);
    }

    public AnalyticsConfiguration getAnalyticsConfiguration(long companyId) {
        return this._analyticsConfigurations.getOrDefault(companyId, this._systemAnalyticsConfiguration);
    }

    public AnalyticsConfiguration getAnalyticsConfiguration(String pid) {
        Long companyId = this._pidCompanyIdMapping.get(pid);
        if (companyId == null) {
            return this._systemAnalyticsConfiguration;
        }
        return this.getAnalyticsConfiguration(companyId);
    }

    public Dictionary<String, Object> getAnalyticsConfigurationProperties(long companyId) {
        if (!this.isActive()) {
            return null;
        }
        Set<Map.Entry<String, Long>> entries = this._pidCompanyIdMapping.entrySet();
        Stream stream = entries.stream();
        String pid = stream.filter(entry -> Objects.equals(entry.getValue(), companyId)).map(Map.Entry::getKey).findFirst().orElse(null);
        if (pid == null) {
            return null;
        }
        try {
            Configuration configuration = this._configurationAdmin.getConfiguration(pid, "?");
            return configuration.getProperties();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get configuration for company " + companyId), (Throwable)exception);
            }
            return null;
        }
    }

    public Map<Long, AnalyticsConfiguration> getAnalyticsConfigurations() {
        return this._analyticsConfigurations;
    }

    public long getCompanyId(String pid) {
        return this._pidCompanyIdMapping.getOrDefault(pid, 0L);
    }

    public String getName() {
        return "com.liferay.analytics.settings.configuration.AnalyticsConfiguration.scoped";
    }

    public boolean isActive() {
        if (!this._active && this._hasConfiguration()) {
            this._active = true;
        } else if (this._active && !this._hasConfiguration()) {
            this._active = false;
        }
        return this._active;
    }

    public void updated(String pid, Dictionary<String, ?> dictionary) {
        this._unmapPid(pid);
        long companyId = GetterUtil.getLong(dictionary.get("companyId"), (long)0L);
        if (companyId != 0L) {
            this._pidCompanyIdMapping.put(pid, companyId);
            this._analyticsConfigurations.put(companyId, (AnalyticsConfiguration)ConfigurableUtil.createConfigurable(AnalyticsConfiguration.class, dictionary));
        }
        if (!this._initializedCompanyIds.contains(companyId)) {
            this._initializedCompanyIds.add(companyId);
            if (Validator.isNotNull(dictionary.get("previousToken"))) {
                return;
            }
        }
        if (Validator.isNull(dictionary.get("token"))) {
            if (Validator.isNotNull(dictionary.get("previousToken"))) {
                this._disable((Long)dictionary.get("companyId"));
            }
        } else {
            if (Validator.isNull(dictionary.get("previousToken"))) {
                this._enable((Long)dictionary.get("companyId"));
            }
            this._sync(dictionary);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._systemAnalyticsConfiguration = (AnalyticsConfiguration)ConfigurableUtil.createConfigurable(AnalyticsConfiguration.class, properties);
    }

    private void _addAnalyticsAdmin(long companyId) throws Exception {
        User user = this._userLocalService.fetchUserByScreenName(companyId, "analytics.administrator");
        if (user != null) {
            return;
        }
        Company company = this._companyLocalService.getCompany(companyId);
        Role role = this._roleLocalService.getRole(companyId, "Analytics Administrator");
        user = this._userLocalService.addUser(0L, companyId, true, null, null, false, "analytics.administrator", "analytics.administrator@" + company.getMx(), LocaleUtil.getDefault(), "Analytics", "", "Administrator", 0L, 0L, true, 0, 1, 1970, "", null, null, new long[]{role.getRoleId()}, null, false, new ServiceContext());
        this._userLocalService.updateUser(user);
    }

    private void _addAnalyticsMessages(String action, List<? extends BaseModel> baseModels) {
        if (baseModels.isEmpty()) {
            return;
        }
        Message message = new Message();
        message.put("action", (Object)action);
        message.put("command", (Object)AnalyticsMessagesProcessorCommand.ADD);
        BaseModel baseModel = baseModels.get(0);
        message.put("entityModelListener", this._entityModelListenerTracker.getEntityModelListener(baseModel.getModelClassName()));
        message.setPayload(baseModels);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Queueing add analytics messages message");
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._messageBus.sendMessage("liferay/analytics_messages_processor", message);
            return null;
        });
    }

    private void _addSAPEntry(long companyId) throws Exception {
        String sapEntryName = _SAP_ENTRY_OBJECT[0];
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, sapEntryName);
        if (sapEntry != null) {
            return;
        }
        this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), _SAP_ENTRY_OBJECT[1], false, true, sapEntryName, Collections.singletonMap(LocaleUtil.getDefault(), sapEntryName), new ServiceContext());
    }

    private void _addUsersAnalyticsMessages(List<User> users) {
        ArrayList<AnalyticsUserImpl> analyticsUsers = new ArrayList<AnalyticsUserImpl>(users.size());
        ArrayList<Contact> contacts = new ArrayList<Contact>(users.size());
        for (User user : users) {
            HashMap<String, long[]> memberships = new HashMap<String, long[]>();
            for (EntityModelListener<?> entityModelListener : this._entityModelListenerTracker.getEntityModelListeners()) {
                try {
                    long[] membershipIds = entityModelListener.getMembershipIds(user);
                    if (membershipIds.length == 0) continue;
                    memberships.put(entityModelListener.getModelClassName(), membershipIds);
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            }
            analyticsUsers.add(new AnalyticsUserImpl(user, memberships));
            Contact contact = user.fetchContact();
            if (contact == null) continue;
            contacts.add(contact);
        }
        this._addAnalyticsMessages("update", analyticsUsers);
        this._addAnalyticsMessages("update", contacts);
    }

    private void _deleteAnalyticsAdmin(long companyId) throws Exception {
        User user = this._userLocalService.fetchUserByScreenName(companyId, "analytics.administrator");
        if (user != null) {
            this._userLocalService.deleteUser(user);
        }
    }

    private void _deleteSAPEntry(long companyId) throws Exception {
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, "ANALYTICS_CLOUD_TOKEN");
        if (sapEntry != null) {
            this._sapEntryLocalService.deleteSAPEntry(sapEntry);
        }
    }

    private void _disable(long companyId) {
        try {
            if (companyId != 0L) {
                this._analyticsMessageLocalService.deleteAnalyticsMessages(companyId);
                this._deleteAnalyticsAdmin(companyId);
                this._deleteSAPEntry(companyId);
            }
            if (this._active && !this._hasConfiguration()) {
                this._active = false;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private void _enable(long companyId) {
        try {
            this._active = true;
            this._addAnalyticsAdmin(companyId);
            this._addSAPEntry(companyId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private boolean _hasConfiguration() {
        Configuration[] configurations;
        block4: {
            configurations = null;
            try {
                configurations = this._configurationAdmin.listConfigurations("(service.pid=" + AnalyticsConfiguration.class.getName() + "*)");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)"Unable to list analytics configurations", (Throwable)exception);
            }
        }
        if (configurations == null) {
            return false;
        }
        for (Configuration configuration : configurations) {
            Dictionary properties = configuration.getProperties();
            if (!Validator.isNotNull(properties.get("token"))) continue;
            return true;
        }
        return false;
    }

    private void _sync(Dictionary<String, ?> dictionary) {
        if (Validator.isNotNull(dictionary.get("token")) && Validator.isNull(dictionary.get("previousToken"))) {
            Collection<EntityModelListener<?>> entityModelListeners = this._entityModelListenerTracker.getEntityModelListeners();
            for (EntityModelListener<?> entityModelListener : entityModelListeners) {
                try {
                    entityModelListener.syncAll(((Long)dictionary.get("companyId")).longValue());
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            }
        }
        Object[] previousSyncedContactFieldNames = GetterUtil.getStringValues(dictionary.get("previousSyncedContactFieldNames"));
        Object[] previousSyncedUserFieldNames = GetterUtil.getStringValues(dictionary.get("previousSyncedUserFieldNames"));
        Object[] syncedContactFieldNames = GetterUtil.getStringValues(dictionary.get("syncedContactFieldNames"));
        Object[] syncedUserFieldNames = GetterUtil.getStringValues(dictionary.get("syncedUserFieldNames"));
        Arrays.sort(previousSyncedContactFieldNames);
        Arrays.sort(previousSyncedUserFieldNames);
        Arrays.sort(syncedContactFieldNames);
        Arrays.sort(syncedUserFieldNames);
        if (!Arrays.equals(previousSyncedUserFieldNames, syncedUserFieldNames)) {
            this._syncUserCustomFields((Long)dictionary.get("companyId"), (String[])syncedUserFieldNames);
        }
        if (!Arrays.equals(previousSyncedContactFieldNames, syncedContactFieldNames) || !Arrays.equals(previousSyncedUserFieldNames, syncedUserFieldNames)) {
            this._syncDefaultFields((Long)dictionary.get("companyId"), (String[])syncedContactFieldNames, (String[])syncedUserFieldNames);
        }
        if (GetterUtil.getBoolean(dictionary.get("syncAllContacts"))) {
            if (!GetterUtil.getBoolean(dictionary.get("previousSyncAllContacts"))) {
                this._syncContacts((Long)dictionary.get("companyId"));
            }
        } else {
            this._syncOrganizationUsers((String[])dictionary.get("syncedOrganizationIds"));
            this._syncUserGroupUsers((String[])dictionary.get("syncedUserGroupIds"));
        }
        Message message = new Message();
        message.put("command", (Object)AnalyticsMessagesProcessorCommand.SEND);
        message.put("companyId", dictionary.get("companyId"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Queueing send analytics messages message");
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._messageBus.sendMessage("liferay/analytics_messages_processor", message);
            return null;
        });
    }

    private void _syncContacts(long companyId) {
        int count = this._userLocalService.getCompanyUsersCount(companyId);
        int pages = count / 500;
        for (int i = 0; i <= pages; ++i) {
            int start = i * 500;
            int end = start + 500;
            if (end > count) {
                end = count;
            }
            List users = this._userLocalService.getCompanyUsers(companyId, start, end);
            this._addUsersAnalyticsMessages(users);
        }
    }

    private void _syncDefaultFields(long companyId, String[] syncedContactFieldNames, String[] syncedUserFieldNames) {
        for (Map.Entry<String, String> entry : _defaultFieldNames.entrySet()) {
            String fieldName = entry.getKey();
            if (!ArrayUtil.contains((Object[])syncedContactFieldNames, (Object)fieldName) && !ArrayUtil.contains((Object[])syncedUserFieldNames, (Object)fieldName)) continue;
            JSONObject jsonObject = JSONUtil.put((String)"className", (Object)User.class.getName()).put("companyId", companyId).put("dataType", entry.getValue()).put("name", fieldName);
            try {
                AnalyticsMessage.Builder analyticsMessageBuilder = AnalyticsMessage.builder((String)(User.class.getName() + ".field"));
                analyticsMessageBuilder.action("add");
                analyticsMessageBuilder.object(jsonObject);
                String analyticsMessageJSON = analyticsMessageBuilder.buildJSONString();
                this._analyticsMessageLocalService.addAnalyticsMessage(companyId, this._userLocalService.getDefaultUserId(companyId), analyticsMessageJSON.getBytes(Charset.defaultCharset()));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to add analytics message " + jsonObject.toString()), (Throwable)exception);
            }
        }
    }

    private void _syncOrganizationUsers(String[] organizationIds) {
        for (String organizationId : organizationIds) {
            int count = this._userLocalService.getOrganizationUsersCount(GetterUtil.getLong((String)organizationId));
            int pages = count / 500;
            for (int i = 0; i <= pages; ++i) {
                int start = i * 500;
                int end = start + 500;
                if (end > count) {
                    end = count;
                }
                try {
                    List users = this._userLocalService.getOrganizationUsers(GetterUtil.getLong((String)organizationId), start, end);
                    this._addUsersAnalyticsMessages(users);
                    continue;
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to get organization users for organization " + organizationId), (Throwable)exception);
                }
            }
        }
    }

    private void _syncUserCustomFields(long companyId, String[] syncedUserFieldNames) {
        ArrayList<ExpandoColumn> expandoColumns = new ArrayList<ExpandoColumn>();
        List defaultTableColumns = this._expandoColumnLocalService.getDefaultTableColumns(companyId, User.class.getName());
        for (ExpandoColumn defaultTableColumn : defaultTableColumns) {
            if (!ArrayUtil.contains((Object[])syncedUserFieldNames, (Object)defaultTableColumn.getName())) continue;
            expandoColumns.add(defaultTableColumn);
        }
        if (!expandoColumns.isEmpty()) {
            this._addAnalyticsMessages("add", expandoColumns);
        }
    }

    private void _syncUserGroupUsers(String[] userGroupIds) {
        for (String userGroupId : userGroupIds) {
            int count = this._userLocalService.getUserGroupUsersCount(GetterUtil.getLong((String)userGroupId));
            int pages = count / 500;
            for (int i = 0; i <= pages; ++i) {
                int start = i * 500;
                int end = start + 500;
                if (end > count) {
                    end = count;
                }
                List users = this._userLocalService.getUserGroupUsers(GetterUtil.getLong((String)userGroupId), start, end);
                this._addUsersAnalyticsMessages(users);
            }
        }
    }

    private void _unmapPid(String pid) {
        Long companyId = this._pidCompanyIdMapping.remove(pid);
        if (companyId != null) {
            this._analyticsConfigurations.remove(companyId);
        }
    }
}

