/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.announcements.uad.display;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.AnnouncementsEntryLocalService;
import com.liferay.announcements.uad.constants.AnnouncementsUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the announcements entry UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in {@link
 * AnnouncementsEntryUADDisplay}.
 * </p>
 *
 * @author William Newbury
 */
public abstract class BaseAnnouncementsEntryUADDisplay
	extends BaseModelUADDisplay<AnnouncementsEntry> {

	@Override
	public AnnouncementsEntry get(Serializable primaryKey) throws Exception {
		return announcementsEntryLocalService.getAnnouncementsEntry(
			Long.valueOf(primaryKey.toString()));
	}

	public String[] getDisplayFieldNames() {
		return new String[] {"title", "content"};
	}

	@Override
	public Class<AnnouncementsEntry> getTypeClass() {
		return AnnouncementsEntry.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return announcementsEntryLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return announcementsEntryLocalService.dynamicQuery();
	}

	@Override
	protected List<AnnouncementsEntry> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return announcementsEntryLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return AnnouncementsUADConstants.
			USER_ID_FIELD_NAMES_ANNOUNCEMENTS_ENTRY;
	}

	@Reference
	protected AnnouncementsEntryLocalService announcementsEntryLocalService;

}