/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.announcements.uad.anonymizer;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.AnnouncementsEntryLocalService;
import com.liferay.announcements.uad.constants.AnnouncementUADConstants;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the announcements entry UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link AnnouncementsEntryUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseAnnouncementsEntryUADAnonymizer
	extends DynamicQueryUADAnonymizer<AnnouncementsEntry> {

	@Override
	public void autoAnonymize(
			AnnouncementsEntry announcementsEntry, long userId,
			User anonymousUser)
		throws PortalException {

		if (announcementsEntry.getUserId() == userId) {
			announcementsEntry.setUserId(anonymousUser.getUserId());
			announcementsEntry.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(announcementsEntry, anonymousUser);
		}

		announcementsEntryLocalService.updateAnnouncementsEntry(
			announcementsEntry);
	}

	@Override
	public void delete(AnnouncementsEntry announcementsEntry)
		throws PortalException {

		announcementsEntryLocalService.deleteEntry(announcementsEntry);
	}

	@Override
	public Class<AnnouncementsEntry> getTypeClass() {
		return AnnouncementsEntry.class;
	}

	protected void autoAnonymizeAssetEntry(
		AnnouncementsEntry announcementsEntry, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(announcementsEntry);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return announcementsEntryLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return AnnouncementUADConstants.USER_ID_FIELD_NAMES_ANNOUNCEMENTS_ENTRY;
	}

	protected AssetEntry fetchAssetEntry(
		AnnouncementsEntry announcementsEntry) {

		return assetEntryLocalService.fetchEntry(
			AnnouncementsEntry.class.getName(),
			announcementsEntry.getEntryId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected AnnouncementsEntryLocalService announcementsEntryLocalService;

}