/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.announcements.uad.anonymizer;

import com.liferay.announcements.kernel.model.AnnouncementsFlag;
import com.liferay.announcements.kernel.service.AnnouncementsFlagLocalService;
import com.liferay.announcements.uad.constants.AnnouncementUADConstants;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the announcements flag UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link AnnouncementsFlagUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseAnnouncementsFlagUADAnonymizer
	extends DynamicQueryUADAnonymizer<AnnouncementsFlag> {

	@Override
	public void autoAnonymize(
			AnnouncementsFlag announcementsFlag, long userId,
			User anonymousUser)
		throws PortalException {

		if (announcementsFlag.getUserId() == userId) {
			announcementsFlag.setUserId(anonymousUser.getUserId());

			autoAnonymizeAssetEntry(announcementsFlag, anonymousUser);
		}

		announcementsFlagLocalService.updateAnnouncementsFlag(
			announcementsFlag);
	}

	@Override
	public void delete(AnnouncementsFlag announcementsFlag)
		throws PortalException {

		announcementsFlagLocalService.deleteFlag(announcementsFlag);
	}

	@Override
	public Class<AnnouncementsFlag> getTypeClass() {
		return AnnouncementsFlag.class;
	}

	protected void autoAnonymizeAssetEntry(
		AnnouncementsFlag announcementsFlag, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(announcementsFlag);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return announcementsFlagLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return AnnouncementUADConstants.USER_ID_FIELD_NAMES_ANNOUNCEMENTS_FLAG;
	}

	protected AssetEntry fetchAssetEntry(AnnouncementsFlag announcementsFlag) {
		return assetEntryLocalService.fetchEntry(
			AnnouncementsFlag.class.getName(), announcementsFlag.getFlagId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected AnnouncementsFlagLocalService announcementsFlagLocalService;

}