/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.announcements.uad.display;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.AnnouncementsEntryLocalService;
import com.liferay.announcements.uad.constants.AnnouncementUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the AnnouncementsEntry UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link AnnouncementsEntryUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseAnnouncementsEntryUADDisplay
	extends BaseModelUADDisplay<AnnouncementsEntry> {

	@Override
	public AnnouncementsEntry get(Serializable primaryKey)
		throws PortalException {

		return announcementsEntryLocalService.getAnnouncementsEntry(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"title", "content"};
	}

	@Override
	public Class<AnnouncementsEntry> getTypeClass() {
		return AnnouncementsEntry.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return announcementsEntryLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return announcementsEntryLocalService.dynamicQuery();
	}

	@Override
	protected List<AnnouncementsEntry> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return announcementsEntryLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return AnnouncementUADConstants.USER_ID_FIELD_NAMES_ANNOUNCEMENTS_ENTRY;
	}

	@Reference
	protected AnnouncementsEntryLocalService announcementsEntryLocalService;

}