/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.announcements.uad.anonymizer;

import com.liferay.announcements.kernel.model.AnnouncementsFlag;
import com.liferay.announcements.kernel.service.AnnouncementsFlagLocalService;
import com.liferay.announcements.uad.constants.AnnouncementUADConstants;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAnnouncementsFlagUADAnonymizer
extends DynamicQueryUADAnonymizer<AnnouncementsFlag> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected AnnouncementsFlagLocalService announcementsFlagLocalService;

    public void autoAnonymize(AnnouncementsFlag announcementsFlag, long userId, User anonymousUser) throws PortalException {
        if (announcementsFlag.getUserId() == userId) {
            announcementsFlag.setUserId(anonymousUser.getUserId());
            this.autoAnonymizeAssetEntry(announcementsFlag, anonymousUser);
        }
        this.announcementsFlagLocalService.updateAnnouncementsFlag(announcementsFlag);
    }

    public void delete(AnnouncementsFlag announcementsFlag) throws PortalException {
        this.announcementsFlagLocalService.deleteFlag(announcementsFlag);
    }

    public Class<AnnouncementsFlag> getTypeClass() {
        return AnnouncementsFlag.class;
    }

    protected void autoAnonymizeAssetEntry(AnnouncementsFlag announcementsFlag, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(announcementsFlag);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.announcementsFlagLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return AnnouncementUADConstants.USER_ID_FIELD_NAMES_ANNOUNCEMENTS_FLAG;
    }

    protected AssetEntry fetchAssetEntry(AnnouncementsFlag announcementsFlag) {
        return this.assetEntryLocalService.fetchEntry(AnnouncementsFlag.class.getName(), announcementsFlag.getFlagId());
    }
}

