/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.resource;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.verifier.VerifierPlugin;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class AddResourceVerifierPlugin
implements VerifierPlugin {
    public void verify(Analyzer analyzer) throws Exception {
        Parameters parameters = OSGiHeader.parseHeader((String)analyzer.getProperty("-add-resource"));
        if (parameters.isEmpty()) {
            return;
        }
        final Jar jar = analyzer.getJar();
        for (String path : parameters.keySet()) {
            final Path jspClassesDir = Paths.get(path, new String[0]);
            if (!Files.exists(jspClassesDir, new LinkOption[0])) continue;
            Files.walkFileTree(jspClassesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    String relativePathString = String.valueOf(jspClassesDir.relativize(path));
                    jar.putResource(relativePathString.replace('\\', '/'), (Resource)new FileResource(path.toAbsolutePath()), true);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

