/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.mirrors.get;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Checksum;

public class MirrorsGetTask
extends Task {
    private static final Pattern _basicAuthenticationURLPattern = Pattern.compile("(https?://)([^:]+):([^@]+)@(.+)");
    private static final Pattern _mirrorsHostNamePattern = Pattern.compile("^mirrors\\.[^\\.]+\\.liferay.com/");
    private static final Pattern _srcPattern = Pattern.compile("https?://(.+/)(.+)");
    private File _dest;
    private String _fileName;
    private boolean _force;
    private boolean _ignoreErrors;
    private String _mirrorsHostname;
    private String _password;
    private String _path;
    private int _retries = 1;
    private boolean _skipChecksum;
    private String _src;
    private boolean _ssl;
    private boolean _tryLocalNetwork = true;
    private String _userAgent;
    private String _username;
    private boolean _verbose;

    public void execute() throws BuildException {
        try {
            this._execute();
        }
        catch (IOException ioException) {
            throw new BuildException((Throwable)ioException);
        }
    }

    public void setDest(File dest) {
        String destPath = dest.getPath();
        if (destPath.matches(".*\\$\\{.+\\}.*")) {
            Project project = this.getProject();
            this._dest = new File(project.replaceProperties(destPath));
        } else {
            this._dest = dest;
        }
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this._ignoreErrors = ignoreErrors;
    }

    public void setPassword(String password) {
        if (this._password == null) {
            this._password = password;
        }
    }

    public void setRetries(int retries) {
        this._retries = retries;
    }

    public void setSkipChecksum(boolean skipChecksum) {
        this._skipChecksum = skipChecksum;
    }

    public void setSrc(String src) {
        Matcher matcher = _basicAuthenticationURLPattern.matcher(src);
        if (matcher.matches()) {
            this._username = matcher.group(2);
            this._password = matcher.group(3);
            src = matcher.group(1) + matcher.group(4);
        }
        Project project = this.getProject();
        this._src = project.replaceProperties(src);
        if (this._src.startsWith("file:")) {
            return;
        }
        matcher = _srcPattern.matcher(this._src);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid src attribute: " + this._src);
        }
        this._fileName = matcher.group(2);
        this._path = matcher.group(1);
        if (this._path.startsWith("mirrors/")) {
            this._path = this._path.replaceFirst("mirrors", this._getMirrorsHostname());
        }
        while (this._path.endsWith("/")) {
            this._path = this._path.substring(0, this._path.length() - 1);
        }
    }

    public void setSSL(boolean ssl) {
        this._ssl = ssl;
    }

    public void setTryLocalNetwork(boolean tryLocalNetwork) {
        this._tryLocalNetwork = tryLocalNetwork;
    }

    public void setUsername(String username) {
        if (this._username == null) {
            this._username = username;
        }
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    private void _copyFile(File sourceFile, File targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Copying ");
        sb.append(sourceFile.getPath());
        sb.append(" to ");
        sb.append(targetFile.getPath());
        sb.append(".");
        System.out.println(sb.toString());
        URI sourceFileURI = sourceFile.toURI();
        long time = System.currentTimeMillis();
        int size = this._toFile(sourceFileURI.toURL(), targetFile);
        if (this._verbose) {
            sb = new StringBuilder();
            sb.append("Copied ");
            sb.append(size);
            sb.append(" bytes in ");
            sb.append(System.currentTimeMillis() - time);
            sb.append(" milliseconds.");
            System.out.println(sb.toString());
        }
    }

    private void _downloadFile(URL sourceURL, File targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Downloading ");
        sb.append(sourceURL.toExternalForm());
        sb.append(" to ");
        sb.append(targetFile.getPath());
        sb.append(".");
        System.out.println(sb.toString());
        long time = System.currentTimeMillis();
        int size = 0;
        try {
            size = this._toFile(sourceURL, targetFile);
        }
        catch (IOException ioException) {
            targetFile.delete();
            if (!this._ignoreErrors) {
                throw ioException;
            }
            ioException.printStackTrace();
        }
        if (this._verbose) {
            sb = new StringBuilder();
            sb.append("Downloaded ");
            sb.append(sourceURL.toExternalForm());
            sb.append(". ");
            sb.append(size);
            sb.append(" bytes in ");
            sb.append(System.currentTimeMillis() - time);
            sb.append(" milliseconds.");
            System.out.println(sb.toString());
        }
        if (!this._isValidMD5(targetFile, new URL(sourceURL.toExternalForm() + ".md5"))) {
            targetFile.delete();
            throw new IOException(targetFile.getAbsolutePath() + " failed checksum");
        }
        if (this._isZipFileName(targetFile.getName()) && !this._isZipFile(targetFile)) {
            targetFile.delete();
            throw new IOException(targetFile.getAbsolutePath() + " is an invalid ZIP file");
        }
        if (this._is7zFileName(targetFile.getName()) && !this._is7zFile(targetFile)) {
            targetFile.delete();
            throw new IOException(targetFile.getAbsolutePath() + " is an invalid 7z file");
        }
    }

    private void _downloadFile(URL sourceURL, File targetFile, int retries) throws IOException {
        if (retries > 0) {
            for (int i = 0; i < retries; ++i) {
                try {
                    this._downloadFile(sourceURL, targetFile);
                    return;
                }
                catch (IOException ioException) {
                    System.out.println("Unable to connect to " + sourceURL + ", will retry in 30 seconds.");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
            }
        }
        this._downloadFile(sourceURL, targetFile);
    }

    private void _execute() throws IOException {
        if (this._src.startsWith("file:")) {
            File srcFile = new File(this._src.substring("file:".length()));
            File targetFile = this._dest;
            if (this._dest.exists() && this._dest.isDirectory()) {
                targetFile = new File(this._dest, srcFile.getName());
            }
            this._copyFile(srcFile, targetFile);
            return;
        }
        Matcher matcher = _mirrorsHostNamePattern.matcher(this._path);
        if (this._tryLocalNetwork && matcher.find()) {
            String hostname = matcher.group();
            System.out.println("The src attribute has an unnecessary reference to " + hostname);
            this._path = this._path.substring(hostname.length());
            while (this._path.startsWith("/")) {
                this._path = this._path.substring(1);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.home"));
        sb.append(File.separator);
        sb.append(".liferay");
        sb.append(File.separator);
        sb.append("mirrors");
        sb.append(File.separator);
        sb.append(this._getPlatformIndependentPath(this._path));
        File localCacheDir = new File(sb.toString());
        File localCacheFile = new File(localCacheDir, this._fileName);
        if (localCacheFile.exists() && !this._force && this._isZipFileName(this._fileName)) {
            boolean bl = this._force = !this._isZipFile(localCacheFile);
        }
        if (localCacheFile.exists() && this._force) {
            localCacheFile.delete();
        }
        if (!localCacheFile.exists()) {
            String mirrorsHostname = this._getMirrorsHostname();
            if (this._tryLocalNetwork && !mirrorsHostname.isEmpty()) {
                sb = new StringBuilder();
                sb.append(this._getURLScheme());
                sb.append(mirrorsHostname);
                sb.append("/");
                sb.append(this._path);
                sb.append("/");
                sb.append(this._fileName);
                URL sourceURL = new URL(sb.toString());
                try {
                    this._downloadFile(sourceURL, localCacheFile, this._retries);
                }
                catch (IOException ioException) {
                    URL defaultURL = new URL(this._src);
                    System.out.println("Unable to connect to " + sourceURL + ", defaulting to " + defaultURL);
                    this._downloadFile(defaultURL, localCacheFile, 0);
                }
            } else {
                this._downloadFile(new URL(this._src), localCacheFile, 0);
            }
        }
        if (this._dest.exists() && this._dest.isDirectory()) {
            this._copyFile(localCacheFile, new File(this._dest, this._fileName));
        } else {
            this._copyFile(localCacheFile, this._dest);
        }
    }

    private Process _executeCommands(String[] commands) throws InterruptedException, IOException, RuntimeException {
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        Process process = processBuilder.start();
        process.waitFor();
        return process;
    }

    private String _getMirrorsHostname() {
        if (this._mirrorsHostname != null) {
            return this._mirrorsHostname;
        }
        Project project = this.getProject();
        this._mirrorsHostname = project.getProperty("mirrors.hostname");
        if (this._mirrorsHostname == null) {
            this._mirrorsHostname = "";
        }
        return this._mirrorsHostname;
    }

    private String _getPassword() {
        if (this._password != null) {
            return this._password;
        }
        Project project = this.getProject();
        this._password = project.getProperty("mirrors.password");
        return this._password;
    }

    private String _getPlatformIndependentPath(String path) {
        String[] separators;
        for (String separator : separators = new String[]{"/", "\\"}) {
            if (separator.equals(File.separator)) continue;
            path = path.replace(separator, File.separator);
        }
        return path;
    }

    private String _getProcessOutput(Process process) {
        StringBuilder processOutput = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedReader.readLine();
            while (line != null) {
                processOutput.append(line);
                processOutput.append(System.lineSeparator());
                line = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to get process output.");
            exception.printStackTrace();
        }
        return processOutput.toString();
    }

    private String _getURLScheme() {
        Project project = this.getProject();
        boolean ssl = this._ssl;
        String mirrorsSSL = project.getProperty("mirrors.ssl");
        if (mirrorsSSL != null && !mirrorsSSL.isEmpty()) {
            ssl = Boolean.parseBoolean(mirrorsSSL);
        }
        if (ssl) {
            return "https://";
        }
        return "http://";
    }

    private String _getUserAgent() {
        if (this._userAgent != null) {
            return this._userAgent;
        }
        Project project = this.getProject();
        this._userAgent = project.getProperty("mirrors.user.agent");
        return this._userAgent;
    }

    private String _getUsername() {
        if (this._username != null) {
            return this._username;
        }
        Project project = this.getProject();
        this._username = project.getProperty("mirrors.username");
        return this._username;
    }

    private boolean _has7z() {
        String[] commands = new String[]{"/bin/bash", "-c", "type 7z"};
        try {
            Process process = this._executeCommands(commands);
            if (process.exitValue() != 0) {
                System.out.println("Unable to validate 7z file.");
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to validate 7z file.");
            return false;
        }
        return true;
    }

    private boolean _is7zFile(File file) {
        if (!this._has7z()) {
            return true;
        }
        String[] commands = new String[]{"/bin/bash", "-c", "7z t " + file.toString()};
        Process process = null;
        try {
            process = this._executeCommands(commands);
        }
        catch (Exception exception) {
            System.out.println(file + " is invalid.");
            return false;
        }
        String processOutput = this._getProcessOutput(process);
        int exitValue = process.exitValue();
        if (exitValue == 0 && !processOutput.contains("Files: 0\n")) {
            return true;
        }
        System.out.println(processOutput);
        System.out.println(file + " is invalid.");
        return false;
    }

    private boolean _is7zFileName(String fileName) {
        return fileName.endsWith(".7z");
    }

    private boolean _isValidMD5(File file, URL url) throws IOException {
        if (this._skipChecksum) {
            return true;
        }
        if (file == null || !file.exists()) {
            return false;
        }
        String remoteMD5 = null;
        try {
            remoteMD5 = this._toString(url);
        }
        catch (Exception exception) {
            if (this._verbose) {
                System.out.println("Unable to access MD5 file");
            }
            return true;
        }
        Checksum checksum = new Checksum();
        checksum.setAlgorithm("MD5");
        checksum.setFile(file);
        checksum.setProject(new Project());
        checksum.setProperty("md5");
        checksum.execute();
        Project project = checksum.getProject();
        String localMD5 = project.getProperty("md5");
        return remoteMD5.contains(localMD5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isZipFile(File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file, 1);
            int count = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++count;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(file.getPath());
            sb.append(" is a valid zip file with ");
            sb.append(count);
            sb.append(" entries.");
            System.out.println(sb.toString());
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            System.out.println(file.getPath() + " is an invalid zip file.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private boolean _isZipFileName(String fileName) {
        return fileName.endsWith(".ear") || fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".zip");
    }

    private URLConnection _openConnection(URL url) throws IOException {
        URLConnection urlConnection = null;
        while ((urlConnection = url.openConnection()) instanceof HttpURLConnection) {
            int responseCode;
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            String password = this._getPassword();
            String username = this._getUsername();
            if (password != null && username != null) {
                String auth = username + ":" + password;
                Base64.Encoder encoder = Base64.getEncoder();
                httpURLConnection.setRequestProperty("Authorization", "Basic " + encoder.encodeToString(auth.getBytes()));
            }
            if (this._getUserAgent() != null) {
                httpURLConnection.setRequestProperty("User-Agent", this._getUserAgent());
            }
            if ((responseCode = httpURLConnection.getResponseCode()) != 301 && responseCode != 302) break;
            url = new URL(httpURLConnection.getHeaderField("Location"));
        }
        return urlConnection;
    }

    private int _toFile(URL url, File file) throws IOException {
        File dir;
        if (file.exists()) {
            file.delete();
        }
        if ((dir = file.getParentFile()) != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            int n = this._toOutputStream(url, outputStream);
            return n;
        }
        catch (IOException ioException) {
            if (file.exists()) {
                file.delete();
            }
            throw ioException;
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _toOutputStream(URL url, OutputStream outputStream) throws IOException {
        URLConnection urlConnection = this._openConnection(url);
        InputStream inputStream = urlConnection.getInputStream();
        try {
            byte[] bytes = new byte[16384];
            int read = 0;
            int size = 0;
            long time = System.currentTimeMillis();
            while ((read = inputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, read);
                size += read;
                if (!this._verbose || System.currentTimeMillis() - time <= 100L) continue;
                System.out.print(".");
                time = System.currentTimeMillis();
            }
            if (this._verbose) {
                System.out.println("\n");
            }
            int n = size;
            return n;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _toString(URL url) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this._toOutputStream(url, outputStream);
            String string = ((Object)outputStream).toString();
            return string;
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }
}

