/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.deploy.hot;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.adapter.PortletPanelAppAdapter;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PortletCategoryUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={HotDeployListener.class})
public class LegacyPortletPanelAppHotDeployListener
extends BaseHotDeployListener {
    private BundleContext _bundleContext;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    private final Map<String, ServiceRegistration<PanelApp>> _serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<PanelApp>>();

    public int getServiceRegistrationsSize() {
        return this._serviceRegistrations.size();
    }

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            for (Dictionary<String, Object> properties : this.getPropertiesList(hotDeployEvent)) {
                String portletId = (String)properties.get("panel.app.portlet.id");
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(PanelApp.class, (Object)new PortletPanelAppAdapter(portletId, () -> this._portletLocalService.getPortletById(portletId)), properties);
                this._serviceRegistrations.put(portletId, (ServiceRegistration<PanelApp>)serviceRegistration);
            }
        }
        catch (DocumentException | IOException exception) {
            throw new HotDeployException(exception);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            for (Dictionary<String, Object> properties : this.getPropertiesList(hotDeployEvent)) {
                String portletId = (String)properties.get("panel.app.portlet.id");
                ServiceRegistration<PanelApp> serviceRegistration = this._serviceRegistrations.remove(portletId);
                if (serviceRegistration == null) continue;
                serviceRegistration.unregister();
            }
        }
        catch (DocumentException | IOException exception) {
            throw new HotDeployException(exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected String getPortletId(String servletContextName, String portletName) {
        if (servletContextName == null) {
            return portletName;
        }
        return this._portal.getJsSafePortletId(portletName + "_WAR_" + servletContextName);
    }

    protected List<Dictionary<String, Object>> getPropertiesList(HotDeployEvent hotDeployEvent) throws DocumentException, IOException {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-portlet.xml"));
        if (xml == null) {
            return Collections.emptyList();
        }
        ArrayList<Dictionary<String, Object>> propertiesList = new ArrayList<Dictionary<String, Object>>();
        Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        Iterator iterator = rootElement.elementIterator("portlet");
        while (iterator.hasNext()) {
            Element portletElement = (Element)iterator.next();
            String controlPanelEntryCategory = portletElement.elementText("control-panel-entry-category");
            if (Validator.isNull((String)controlPanelEntryCategory)) continue;
            controlPanelEntryCategory = PortletCategoryUtil.getPortletCategoryKey((String)controlPanelEntryCategory);
            propertiesList.add((Dictionary<String, Object>)HashMapDictionaryBuilder.put((Object)"panel.app.order", () -> {
                String controlPanelEntryWeight = portletElement.elementText("control-panel-entry-weight");
                if (Validator.isNotNull((String)controlPanelEntryWeight)) {
                    return (int)Math.ceil(GetterUtil.getDouble((String)controlPanelEntryWeight) * 100.0);
                }
                return null;
            }).put((Object)"panel.app.portlet.id", (Object)this.getPortletId(hotDeployEvent.getServletContextName(), portletElement.elementText("portlet-name"))).put((Object)"panel.category.key", (Object)controlPanelEntryCategory).build());
        }
        return propertiesList;
    }
}

