/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.application.list.util.PanelCategoryServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={PanelCategoryRegistry.class})
public class PanelCategoryRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PanelCategoryRegistry.class);
    private ServiceTrackerMap<String, List<PanelCategory>> _childPanelCategoriesServiceTrackerMap;
    private ServiceTrackerMap<String, PanelCategory> _panelCategoryServiceTrackerMap;

    public List<PanelCategory> getChildPanelCategories(PanelCategory panelCategory) {
        return this.getChildPanelCategories(panelCategory.getKey());
    }

    public List<PanelCategory> getChildPanelCategories(PanelCategory panelCategory, PermissionChecker permissionChecker, Group group) {
        return this.getChildPanelCategories(panelCategory.getKey(), permissionChecker, group);
    }

    public List<PanelCategory> getChildPanelCategories(String panelCategoryKey) {
        List childPanelCategories = (List)this._childPanelCategoriesServiceTrackerMap.getService((Object)panelCategoryKey);
        if (childPanelCategories == null) {
            return Collections.emptyList();
        }
        return childPanelCategories;
    }

    public List<PanelCategory> getChildPanelCategories(String panelCategoryKey, final PermissionChecker permissionChecker, final Group group) {
        List<PanelCategory> panelCategories = this.getChildPanelCategories(panelCategoryKey);
        if (panelCategories.isEmpty()) {
            return panelCategories;
        }
        return ListUtil.filter(panelCategories, (PredicateFilter)new PredicateFilter<PanelCategory>(){

            public boolean filter(PanelCategory panelCategory) {
                try {
                    return panelCategory.isShow(permissionChecker, group);
                }
                catch (PortalException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    return false;
                }
            }
        });
    }

    public int getChildPanelCategoriesNotificationsCount(PanelCategoryHelper panelCategoryHelper, String panelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = 0;
        for (PanelCategory panelCategory : this.getChildPanelCategories(panelCategoryKey)) {
            int notificationsCount = panelCategory.getNotificationsCount(panelCategoryHelper, permissionChecker, group, user);
            try {
                if (notificationsCount <= 0 || !panelCategory.isShow(permissionChecker, group)) continue;
                count += notificationsCount;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return count;
    }

    public PanelCategory getFirstChildPanelCategory(String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelCategory> panelCategories = this.getChildPanelCategories(panelCategoryKey);
        for (PanelCategory panelCategory : panelCategories) {
            try {
                if (!panelCategory.isShow(permissionChecker, group)) continue;
                return panelCategory;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return null;
    }

    public PanelCategory getPanelCategory(String panelCategoryKey) {
        PanelCategory panelCategory = (PanelCategory)this._panelCategoryServiceTrackerMap.getService((Object)panelCategoryKey);
        if (panelCategory == null) {
            throw new IllegalArgumentException("No panel category found with key " + panelCategoryKey);
        }
        return panelCategory;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._childPanelCategoriesServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PanelCategory.class, (String)"(panel.category.key=*)", (ServiceReferenceMapper)new PanelCategoryServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("panel.category.order")));
        this._panelCategoryServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PanelCategory.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, PanelCategory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void map(ServiceReference<PanelCategory> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                PanelCategory panelCategory = (PanelCategory)bundleContext.getService(serviceReference);
                try {
                    emitter.emit((Object)panelCategory.getKey());
                }
                finally {
                    bundleContext.ungetService(serviceReference);
                }
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._childPanelCategoriesServiceTrackerMap.close();
        this._panelCategoryServiceTrackerMap.close();
    }
}

