/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.exportimport.data.handler;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class AssetDisplayPageStagedModelDataHandler
extends BaseStagedModelDataHandler<AssetDisplayPageEntry> {
    public static final String[] CLASS_NAMES = new String[]{AssetDisplayPageEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayPageStagedModelDataHandler.class);
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.asset.display.page.model.AssetDisplayPageEntry)")
    private StagedModelRepository<AssetDisplayPageEntry> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, AssetDisplayPageEntry assetDisplayPageEntry) throws Exception {
        Element assetDisplayPageElement = portletDataContext.getExportDataElement((ClassedModel)assetDisplayPageEntry);
        portletDataContext.addClassedModel(assetDisplayPageElement, ExportImportPathUtil.getModelPath((StagedModel)assetDisplayPageEntry), (ClassedModel)assetDisplayPageEntry);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(assetDisplayPageEntry.getLayoutPageTemplateEntryId());
        if (layoutPageTemplateEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)assetDisplayPageEntry, (StagedModel)layoutPageTemplateEntry, (String)"dependency");
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, AssetDisplayPageEntry assetDisplayPageEntry) throws Exception {
        AssetDisplayPageEntry importedAssetDisplayPageEntry = (AssetDisplayPageEntry)assetDisplayPageEntry.clone();
        long layoutPageTemplateEntryId = 0L;
        if (importedAssetDisplayPageEntry.getLayoutPageTemplateEntryId() > 0L) {
            Map layoutPageTemplateEntryIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateEntry.class);
            layoutPageTemplateEntryId = MapUtil.getLong((Map)layoutPageTemplateEntryIds, (long)assetDisplayPageEntry.getLayoutPageTemplateEntryId(), (long)assetDisplayPageEntry.getLayoutPageTemplateEntryId());
        }
        Map plids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        importedAssetDisplayPageEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedAssetDisplayPageEntry.setCompanyId(portletDataContext.getCompanyId());
        importedAssetDisplayPageEntry.setLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
        importedAssetDisplayPageEntry.setPlid(MapUtil.getLong((Map)plids, (long)assetDisplayPageEntry.getPlid(), (long)assetDisplayPageEntry.getPlid()));
        Map newClassPKsMap = portletDataContext.getNewPrimaryKeysMap(importedAssetDisplayPageEntry.getClassName());
        long existingClassPK = MapUtil.getLong((Map)newClassPKsMap, (long)importedAssetDisplayPageEntry.getClassPK(), (long)importedAssetDisplayPageEntry.getClassPK());
        AssetDisplayPageEntry existingAssetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(portletDataContext.getScopeGroupId(), importedAssetDisplayPageEntry.getClassNameId(), existingClassPK);
        if (existingAssetDisplayPageEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedAssetDisplayPageEntry.setClassPK(existingClassPK);
            try {
                importedAssetDisplayPageEntry = (AssetDisplayPageEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedAssetDisplayPageEntry);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to add asset display page", (Throwable)exception);
                }
                portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)assetDisplayPageEntry));
                return;
            }
        } else {
            importedAssetDisplayPageEntry.setMvccVersion(existingAssetDisplayPageEntry.getMvccVersion());
            importedAssetDisplayPageEntry.setAssetDisplayPageEntryId(existingAssetDisplayPageEntry.getAssetDisplayPageEntryId());
            importedAssetDisplayPageEntry.setClassPK(existingAssetDisplayPageEntry.getClassPK());
            importedAssetDisplayPageEntry = (AssetDisplayPageEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedAssetDisplayPageEntry);
        }
        portletDataContext.importClassedModel((ClassedModel)assetDisplayPageEntry, (ClassedModel)importedAssetDisplayPageEntry);
    }

    protected StagedModelRepository<AssetDisplayPageEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

